<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCustomerEmployeePermissionsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('customer_employee_permissions', function (Blueprint $table) {
            $table->id();
            $table->integer('customer_permission_id')->nullable();
            $table->string('status')->nullable()->default('active');
            $table->integer('customer_id')->nullable();
            $table->integer('workspace_id')->nullable();
            $table->integer('module_id')->nullable();
            $table->string('module_type')->nullable();
            $table->integer('tier_id')->nullable();
            $table->string('del')->nullable()->default('0');
            $table->timestamps();
            
            // Indexes for better query performance
            $table->index(['customer_id', 'workspace_id']);
            $table->index('customer_permission_id');
            $table->index('module_id');
            $table->index('module_type');
            $table->index('tier_id');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('customer_employee_permissions');
    }
}
