<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePermissionTemplateItemsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('permission_template_items', function (Blueprint $table) {
            $table->id();
            $table->integer('template_id')->nullable();
            $table->integer('permission_id')->nullable();
            $table->timestamps();

            // Indexes for better query performance
            $table->index('template_id');
            $table->index('permission_id');
            $table->unique(['template_id', 'permission_id'], 'template_permission_unique');
            $table->index('created_at');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('permission_template_items');
    }
}
