<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Permission;

class PermissionSeeder extends Seeder
{
    /**
     * Generate a unique permission code
     *
     * @return string
     */
    protected function generateUniquePermissionCode()
    {
        do {
            $code = 'PERM-' . strtoupper(substr(uniqid(), -8));
        } while (Permission::where('permission_code', $code)->exists());

        return $code;
    }
    /**
     * Static permissions data from database export
     *
     * @return array
     */
    protected function getStaticPermissions()
    {
        return [
            ['title' => 'Add Employee', 'module_id' => 300, 'module_type' => 'module', 'status' => 'active'],
            ['title' => 'Sync To Xero', 'module_id' => 299, 'module_type' => 'module', 'status' => 'active'],
            ['title' => 'Activate Employee', 'module_id' => 300, 'module_type' => 'module', 'status' => 'active'],
            ['title' => 'Deactivate Employee', 'module_id' => 300, 'module_type' => 'module', 'status' => 'active'],
            ['title' => 'Edit Employee', 'module_id' => 300, 'module_type' => 'module', 'status' => 'active'],
            ['title' => 'Edit', 'module_id' => 747, 'module_type' => 'sub_module', 'status' => 'active'],
            ['title' => 'View Document', 'module_id' => 313, 'module_type' => 'module', 'status' => 'active'],
            ['title' => 'Edit Document', 'module_id' => 313, 'module_type' => 'module', 'status' => 'active'],
            ['title' => 'View File', 'module_id' => 313, 'module_type' => 'module', 'status' => 'active'],
            ['title' => 'Change Status', 'module_id' => 300, 'module_type' => 'module', 'status' => 'active'],
            ['title' => 'Send Credentials', 'module_id' => 311, 'module_type' => 'module', 'status' => 'active'],
            ['title' => 'Invite Employee', 'module_id' => 300, 'module_type' => 'module', 'status' => 'active'],
            ['title' => 'Edit Invite Employee', 'module_id' => 300, 'module_type' => 'module', 'status' => 'active'],
            ['title' => 'Status Employee', 'module_id' => 300, 'module_type' => 'module', 'status' => 'active'],
            ['title' => 'Add', 'module_id' => null, 'module_type' => null, 'status' => 'active'],
            ['title' => 'Delete', 'module_id' => 747, 'module_type' => 'sub_module', 'status' => 'active'],
            ['title' => 'View Document File', 'module_id' => 321, 'module_type' => 'module', 'status' => 'active'],
            ['title' => 'View Signed Document File', 'module_id' => 321, 'module_type' => 'module', 'status' => 'active'],
            ['title' => 'View Signature', 'module_id' => 747, 'module_type' => 'sub_module', 'status' => 'active'],
            ['title' => 'Add Document', 'module_id' => 321, 'module_type' => 'module', 'status' => 'active'],
            ['title' => 'Status Document', 'module_id' => 321, 'module_type' => 'module', 'status' => 'active'],
            ['title' => 'Add Band', 'module_id' => 313, 'module_type' => 'module', 'status' => 'active'],
            ['title' => 'Edit Band', 'module_id' => 313, 'module_type' => 'module', 'status' => 'active'],
            ['title' => 'Delete Band', 'module_id' => 313, 'module_type' => 'module', 'status' => 'active'],
            ['title' => 'Apply Leave', 'module_id' => 189, 'module_type' => 'module', 'status' => 'active'],
            ['title' => 'Assign Shift', 'module_id' => 189, 'module_type' => 'module', 'status' => 'active'],
            ['title' => 'Create Custom Shift', 'module_id' => 189, 'module_type' => 'module', 'status' => 'active'],
            ['title' => 'Edit Shift', 'module_id' => 189, 'module_type' => 'module', 'status' => 'active'],
            ['title' => 'Delete Shift', 'module_id' => 189, 'module_type' => 'module', 'status' => 'active'],
            ['title' => 'Edit Roster', 'module_id' => 189, 'module_type' => 'module', 'status' => 'active'],
            ['title' => 'Delete Roster', 'module_id' => 189, 'module_type' => 'module', 'status' => 'active'],
            ['title' => 'Bulk Edit Roster', 'module_id' => 189, 'module_type' => 'module', 'status' => 'active'],
            ['title' => 'Bulk Schedule Roster', 'module_id' => 189, 'module_type' => 'module', 'status' => 'active'],
            ['title' => 'Bulk Delete Roster', 'module_id' => 189, 'module_type' => 'module', 'status' => 'active'],
            ['title' => 'Attendance Portal', 'module_id' => 231, 'module_type' => 'module', 'status' => 'active'],
            ['title' => 'Edit Attendance Request', 'module_id' => 231, 'module_type' => 'module', 'status' => 'active'],
            ['title' => 'Approve Attendance Request', 'module_id' => 231, 'module_type' => 'module', 'status' => 'active'],
            ['title' => 'Add Attendance', 'module_id' => 231, 'module_type' => 'module', 'status' => 'active'],
            ['title' => 'Edit Attendance', 'module_id' => 231, 'module_type' => 'module', 'status' => 'active'],
            ['title' => 'Delete Attendance', 'module_id' => 231, 'module_type' => 'module', 'status' => 'active'],
            ['title' => 'View Attendance', 'module_id' => 299, 'module_type' => 'module', 'status' => 'active'],
            ['title' => 'Download Selfie', 'module_id' => 231, 'module_type' => 'module', 'status' => 'active'],
            ['title' => 'View Attendance Logs', 'module_id' => 231, 'module_type' => 'module', 'status' => 'active'],
            ['title' => 'Add Over Time', 'module_id' => 857, 'module_type' => 'sub_module', 'status' => 'active'],
            ['title' => 'Edit Over Time', 'module_id' => 857, 'module_type' => 'sub_module', 'status' => 'active'],
            ['title' => 'Delete Over Time', 'module_id' => 857, 'module_type' => 'sub_module', 'status' => 'active'],
            ['title' => 'Approve Over Time', 'module_id' => 857, 'module_type' => 'sub_module', 'status' => 'active'],
            ['title' => 'Reject Over Time', 'module_id' => 857, 'module_type' => 'sub_module', 'status' => 'active'],
            ['title' => 'Back Button', 'module_id' => null, 'module_type' => null, 'status' => 'active'],
            ['title' => 'Edit Button', 'module_id' => null, 'module_type' => null, 'status' => 'active'],
            ['title' => 'Add Leave Type', 'module_id' => null, 'module_type' => null, 'status' => 'active'],
            ['title' => 'Edit Leave Type', 'module_id' => null, 'module_type' => null, 'status' => 'active'],
            ['title' => 'Delete Leave Type', 'module_id' => null, 'module_type' => null, 'status' => 'active'],
            ['title' => 'Add Public Holiday', 'module_id' => null, 'module_type' => null, 'status' => 'active'],
            ['title' => 'Edit Public Holiday', 'module_id' => null, 'module_type' => null, 'status' => 'active'],
            ['title' => 'Delete Public Holiday', 'module_id' => null, 'module_type' => null, 'status' => 'active'],
            ['title' => 'Add Leave Package', 'module_id' => null, 'module_type' => null, 'status' => 'active'],
            ['title' => 'Edit Leave Package', 'module_id' => null, 'module_type' => null, 'status' => 'active'],
            ['title' => 'Delete Leave Package', 'module_id' => null, 'module_type' => null, 'status' => 'active'],
            ['title' => 'Add Leave Request', 'module_id' => null, 'module_type' => null, 'status' => 'active'],
            ['title' => 'Delete Leave Request', 'module_id' => null, 'module_type' => null, 'status' => 'active'],
            ['title' => 'Add Salary', 'module_id' => 299, 'module_type' => 'module', 'status' => 'active'],
            ['title' => 'Edit Salary', 'module_id' => 299, 'module_type' => 'module', 'status' => 'active'],
            ['title' => 'Delete Salary', 'module_id' => 299, 'module_type' => 'module', 'status' => 'active'],
            ['title' => 'Add Bonus', 'module_id' => 299, 'module_type' => 'module', 'status' => 'active'],
            ['title' => 'Edit Bonus', 'module_id' => 299, 'module_type' => 'module', 'status' => 'active'],
            ['title' => 'Delete Bonus', 'module_id' => 299, 'module_type' => 'module', 'status' => 'active'],
            ['title' => 'Generate Selected PaySlip', 'module_id' => 299, 'module_type' => 'module', 'status' => 'active'],
            ['title' => 'Generate PaySlip', 'module_id' => 299, 'module_type' => 'module', 'status' => 'active'],
            ['title' => 'Bulk Delete', 'module_id' => 299, 'module_type' => 'module', 'status' => 'active'],
            ['title' => 'Recipt', 'module_id' => 299, 'module_type' => 'module', 'status' => 'active'],
            ['title' => 'PaidOrUnpaid PaySlip', 'module_id' => 299, 'module_type' => 'module', 'status' => 'active'],
            ['title' => 'Delete PaySlip', 'module_id' => 299, 'module_type' => 'module', 'status' => 'active'],
            ['title' => 'View Subcontractor Details', 'module_id' => 299, 'module_type' => 'module', 'status' => 'active'],
            ['title' => 'Sync TimesheetTo Xero', 'module_id' => 299, 'module_type' => 'module', 'status' => 'active'],
            ['title' => 'Sync EmployeeTo Xero', 'module_id' => 299, 'module_type' => 'module', 'status' => 'active'],
            ['title' => 'Add Super Fund', 'module_id' => null, 'module_type' => null, 'status' => 'active'],
            ['title' => 'Edit Super Fund', 'module_id' => null, 'module_type' => null, 'status' => 'active'],
            ['title' => 'Delete Super Fund', 'module_id' => null, 'module_type' => null, 'status' => 'active'],
            ['title' => 'Download', 'module_id' => 302, 'module_type' => 'module', 'status' => 'active'],
            ['title' => 'Status', 'module_id' => null, 'module_type' => null, 'status' => 'active'],
            ['title' => 'Active Inactive', 'module_id' => 311, 'module_type' => 'module', 'status' => 'active'],
            ['title' => 'Assign Project Tab', 'module_id' => 311, 'module_type' => 'module', 'status' => 'active'],
            ['title' => 'Employees Tab', 'module_id' => 311, 'module_type' => 'module', 'status' => 'active'],
            ['title' => 'Required Document Tab', 'module_id' => 311, 'module_type' => 'module', 'status' => 'active'],
            ['title' => 'View', 'module_id' => 302, 'module_type' => 'module', 'status' => 'active'],
            ['title' => 'Project Assign', 'module_id' => 311, 'module_type' => 'module', 'status' => 'active'],
            ['title' => 'Document Approved Rejected', 'module_id' => 311, 'module_type' => 'module', 'status' => 'active'],
            ['title' => 'History', 'module_id' => null, 'module_type' => null, 'status' => 'active'],
            ['title' => 'Generate Summary', 'module_id' => null, 'module_type' => null, 'status' => 'active'],
            ['title' => 'Calendar Show', 'module_id' => null, 'module_type' => null, 'status' => 'active'],
            ['title' => 'Publish', 'module_id' => null, 'module_type' => null, 'status' => 'active'],
            ['title' => 'OverView Tab', 'module_id' => null, 'module_type' => null, 'status' => 'active'],
            ['title' => 'Packages Scope Tab', 'module_id' => null, 'module_type' => null, 'status' => 'active'],
            ['title' => 'Reply', 'module_id' => null, 'module_type' => null, 'status' => 'active'],
            ['title' => 'Invite Subcontractor', 'module_id' => null, 'module_type' => null, 'status' => 'active'],
            ['title' => 'Send Reminder', 'module_id' => null, 'module_type' => null, 'status' => 'active'],
            ['title' => 'Proceed To Award', 'module_id' => null, 'module_type' => null, 'status' => 'active'],
            ['title' => 'History Tab', 'module_id' => null, 'module_type' => null, 'status' => 'active'],
            ['title' => 'Dependencies View', 'module_id' => null, 'module_type' => null, 'status' => 'active'],
            ['title' => 'generatePDF', 'module_id' => null, 'module_type' => null, 'status' => 'active'],
            ['title' => 'Regenerate PDF', 'module_id' => 747, 'module_type' => 'sub_module', 'status' => 'active'],
            ['title' => 'sendForApproval', 'module_id' => null, 'module_type' => null, 'status' => 'active'],
            ['title' => 'cancelApproval', 'module_id' => null, 'module_type' => null, 'status' => 'active'],
            ['title' => 'Injury Classification', 'module_id' => 873, 'module_type' => 'sub_module', 'status' => 'active'],
            ['title' => 'Notifiable Classification', 'module_id' => 873, 'module_type' => 'sub_module', 'status' => 'active'],
            ['title' => 'Trainings', 'module_id' => 873, 'module_type' => 'sub_module', 'status' => 'active'],
            ['title' => 'Injury Type', 'module_id' => 873, 'module_type' => 'sub_module', 'status' => 'active'],
            ['title' => 'Report Questions', 'module_id' => 873, 'module_type' => 'sub_module', 'status' => 'active'],
            ['title' => 'Generate With AI', 'module_id' => 873, 'module_type' => 'sub_module', 'status' => 'active'],
            ['title' => 'Hazard Risk Tab', 'module_id' => 873, 'module_type' => 'sub_module', 'status' => 'active'],
            ['title' => 'Safety Planning Questions Tab', 'module_id' => 873, 'module_type' => 'sub_module', 'status' => 'active'],
            ['title' => 'General Notes Tab', 'module_id' => 873, 'module_type' => 'sub_module', 'status' => 'active'],
            ['title' => 'Mandatory Ppe Tab', 'module_id' => 873, 'module_type' => 'sub_module', 'status' => 'active'],
            ['title' => 'log', 'module_id' => null, 'module_type' => null, 'status' => 'active'],
            ['title' => 'Portal', 'module_id' => 233, 'module_type' => 'module', 'status' => 'active'],
            ['title' => 'Add Meeting', 'module_id' => 747, 'module_type' => 'sub_module', 'status' => 'active'],
            ['title' => 'Edit Meeting', 'module_id' => 747, 'module_type' => 'sub_module', 'status' => 'active'],
            ['title' => 'Delete Meeting', 'module_id' => 747, 'module_type' => 'sub_module', 'status' => 'active'],
            ['title' => 'Create Setting', 'module_id' => 873, 'module_type' => 'sub_module', 'status' => 'active'],
            ['title' => 'Edit Setting', 'module_id' => 873, 'module_type' => 'sub_module', 'status' => 'active'],
            ['title' => 'Delete Setting', 'module_id' => 873, 'module_type' => 'sub_module', 'status' => 'active'],
            ['title' => 'Dashboard', 'module_id' => 314, 'module_type' => 'module', 'status' => 'active'],
            ['title' => 'Add Asset', 'module_id' => 864, 'module_type' => 'sub_module', 'status' => 'active'],
            ['title' => 'Edit Asset', 'module_id' => 864, 'module_type' => 'sub_module', 'status' => 'active'],
            ['title' => 'Delete Asset', 'module_id' => 864, 'module_type' => 'sub_module', 'status' => 'active'],
            ['title' => 'Add Ticket', 'module_id' => 302, 'module_type' => 'module', 'status' => 'active'],
            ['title' => 'Edit Ticket', 'module_id' => 302, 'module_type' => 'module', 'status' => 'active'],
            ['title' => 'Delete Ticket', 'module_id' => 302, 'module_type' => 'module', 'status' => 'active'],
            ['title' => 'Add Comment', 'module_id' => 302, 'module_type' => 'module', 'status' => 'active'],
            ['title' => 'Update Permission', 'module_id' => 872, 'module_type' => 'sub_module', 'status' => 'active'],
            ['title' => 'Download Invoice', 'module_id' => 871, 'module_type' => 'sub_module', 'status' => 'active'],
            ['title' => 'Brand Settings', 'module_id' => 873, 'module_type' => 'sub_module', 'status' => 'active'],
            ['title' => 'System Settings', 'module_id' => 873, 'module_type' => 'sub_module', 'status' => 'active'],
            ['title' => 'Company Settings', 'module_id' => 873, 'module_type' => 'sub_module', 'status' => 'active'],
            ['title' => 'Bank Details', 'module_id' => 873, 'module_type' => 'sub_module', 'status' => 'active'],
            ['title' => 'Xero Settings', 'module_id' => 873, 'module_type' => 'sub_module', 'status' => 'active'],
            ['title' => 'Email Template Settings', 'module_id' => 873, 'module_type' => 'sub_module', 'status' => 'active'],
            ['title' => 'Employees', 'module_id' => 300, 'module_type' => 'module', 'status' => 'active'],
            ['title' => 'Testing', 'module_id' => 851, 'module_type' => 'sub_module', 'status' => 'active'],
            ['title' => 'Testing 123', 'module_id' => 322, 'module_type' => 'module', 'status' => 'active'],
        ];
    }

    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $permissionsData = $this->getStaticPermissions();

        $this->command->info('Processing ' . count($permissionsData) . ' permissions from static data');

        // Insert permissions into database
        $inserted = 0;
        $updated = 0;
        $skipped = 0;

        foreach ($permissionsData as $permissionData) {
            $title = $permissionData['title'];
            $moduleId = $permissionData['module_id'];
            $moduleType = $permissionData['module_type'];
            $status = $permissionData['status'];

            // Check if permission already exists for the same module
            $existingPermissionQuery = Permission::where('title', $title)
                ->where('del', '0');

            if ($moduleId) {
                $existingPermissionQuery->where('module_id', $moduleId);
                if ($moduleType) {
                    $existingPermissionQuery->where('module_type', $moduleType);
                }
            } else {
                $existingPermissionQuery->whereNull('module_id');
            }

            $existingPermission = $existingPermissionQuery->first();

            if ($existingPermission) {
                // Update existing permission
                $updateData = [
                    'module_id' => $moduleId,
                    'module_type' => $moduleType,
                    'status' => $status,
                ];
                // Generate permission code if it doesn't exist
                if (!$existingPermission->permission_code) {
                    $updateData['permission_code'] = $this->generateUniquePermissionCode();
                }
                $existingPermission->update($updateData);
                $updated++;
            } else {
                // Create new permission
                Permission::create([
                    'title' => $title,
                    'module_id' => $moduleId,
                    'module_type' => $moduleType,
                    'status' => $status,
                    'permission_code' => $this->generateUniquePermissionCode(),
                    'del' => '0',
                ]);
                $inserted++;
            }
        }

        $this->command->info("✓ Inserted {$inserted} new permissions");
        $this->command->info("✓ Updated {$updated} existing permissions");
        if ($skipped > 0) {
            $this->command->info("✓ Skipped {$skipped} permissions");
        }
    }
}
