<?php

namespace Database\Seeders;

use App\Models\Role;
use Illuminate\Database\Seeder;

class RoleSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $roles = [
            // Existing roles with original codes
            ['title' => 'Admin', 'code' => 'A-1'],
            ['title' => 'HR Manager', 'code' => 'HR'],
            ['title' => 'Employee', 'code' => 'EMP'],
            ['title' => 'Subcontractor', 'code' => 'SUB'],
            ['title' => 'Supervisor', 'code' => 'SPV'],
            ['title' => 'Safety Manager', 'code' => 'SM'],
            ['title' => 'Site Safety Officer', 'code' => 'SSO'],
            ['title' => 'Foreman', 'code' => 'FM'],
            ['title' => 'Director', 'code' => 'DIR'],


            ['title' => 'Leading Hand', 'code' => 'LH'],
            ['title' => 'Tradesman', 'code' => 'TM'],
            ['title' => 'Labourer', 'code' => 'LAB'],
            ['title' => 'Visitor', 'code' => 'VIS'],
            ['title' => 'Head Office', 'code' => 'HO'],
            ['title' => 'Formworker', 'code' => 'FW'],
            ['title' => 'Administrative Officer', 'code' => 'AO'],
            ['title' => 'Patcher', 'code' => 'PAT'],
            ['title' => 'Educated Skilled Labourer', 'code' => 'ESL'],
            ['title' => 'Jumpform Formworker', 'code' => 'JFW'],
            ['title' => 'Formworker Stripper m2', 'code' => 'FWS'],
            ['title' => 'Formwork Stripping P/H', 'code' => 'FSP'],
            ['title' => 'Principal Contractor', 'code' => 'PC'],
            ['title' => 'Principal Contractor Scaffolder', 'code' => 'PCS'],
            ['title' => 'Principal Contractor Steelfixer', 'code' => 'PCSF'],
            ['title' => 'Principal Contractor PT', 'code' => 'PCPT'],
            ['title' => 'Principal Contractor Other Trades', 'code' => 'PCOT'],
            ['title' => 'Other Contractors', 'code' => 'OC'],
            ['title' => 'Site Manager', 'code' => 'SMGR'],
            ['title' => 'Project Manager', 'code' => 'PM'],
            ['title' => 'Construction Manager', 'code' => 'CM'],
            ['title' => 'Quality Assurance Manager', 'code' => 'QAM'],
            ['title' => 'Site Engineer', 'code' => 'SE'],
            ['title' => 'Quantity Surveyor', 'code' => 'QS'],
            ['title' => 'Health and Safety Coordinator', 'code' => 'HSC'],
            ['title' => 'Plant Operator', 'code' => 'PO'],
            ['title' => 'Crane Operator', 'code' => 'CO'],
            ['title' => 'Excavator Operator', 'code' => 'EO'],
            ['title' => 'Dozer Operator', 'code' => 'DO'],
            ['title' => 'Grader Operator', 'code' => 'GO'],
            ['title' => 'Loader Operator', 'code' => 'LO'],
            ['title' => 'Roller Operator', 'code' => 'RO'],
            ['title' => 'Concrete Pumper', 'code' => 'CP'],
            ['title' => 'Concrete Finisher', 'code' => 'CF'],
            ['title' => 'Steel Fixer', 'code' => 'SF'],
            ['title' => 'Carpenter', 'code' => 'CAR'],
            ['title' => 'Bricklayer', 'code' => 'BL'],
            ['title' => 'Plasterer', 'code' => 'PL'],
            ['title' => 'Tiler', 'code' => 'TI'],
            ['title' => 'Painter', 'code' => 'PA'],
            ['title' => 'Electrician', 'code' => 'EL'],
            ['title' => 'Plumber', 'code' => 'PLU'],
            ['title' => 'Welder', 'code' => 'WE'],
            ['title' => 'Scaffolder', 'code' => 'SC'],
            ['title' => 'Roofer', 'code' => 'RF'],
            ['title' => 'Glazier', 'code' => 'GL'],
            ['title' => 'Insulation Worker', 'code' => 'IW'],
            ['title' => 'Drywaller', 'code' => 'DW'],
            ['title' => 'Flooring Installer', 'code' => 'FI'],
            ['title' => 'HVAC Technician', 'code' => 'HVAC'],
            ['title' => 'Surveyor', 'code' => 'SUR'],
            ['title' => 'Demolition Worker', 'code' => 'DEM'],
            ['title' => 'Traffic Controller', 'code' => 'TC'],
            ['title' => 'Rigger', 'code' => 'RIG'],
            ['title' => 'Boilermaker', 'code' => 'BM'],
            ['title' => 'Mechanic', 'code' => 'MEC'],
            ['title' => 'Truck Driver', 'code' => 'TD'],
            ['title' => 'Delivery Driver', 'code' => 'DD'],
            ['title' => 'Warehouse Worker', 'code' => 'WW'],
            ['title' => 'Material Handler', 'code' => 'MH'],
            ['title' => 'Site Cleaner', 'code' => 'SCA'],
            ['title' => 'Landscaper', 'code' => 'LA'],
            ['title' => 'Fencer', 'code' => 'FE'],
            ['title' => 'Concreter', 'code' => 'CON'],
            ['title' => 'Driller', 'code' => 'DR'],
            ['title' => 'Blaster', 'code' => 'BLA'],
            ['title' => 'Tunneling Worker', 'code' => 'TW'],
            ['title' => 'Bridge Builder', 'code' => 'BB'],
            ['title' => 'Marine Construction Worker', 'code' => 'MCW'],
            ['title' => 'Pipeline Worker', 'code' => 'PW'],
            ['title' => 'Utility Worker', 'code' => 'UW'],
            ['title' => 'Civil Construction Worker', 'code' => 'CCW'],
            ['title' => 'Road Worker', 'code' => 'RW'],
            ['title' => 'Piling Operator', 'code' => 'PIU'],
            ['title' => 'Asbestos Removalist', 'code' => 'AR'],
            ['title' => 'Environmental Officer', 'code' => 'EO2'],
            ['title' => 'Site Clerk', 'code' => 'SCL'],
            ['title' => 'Storeman', 'code' => 'STR'],
            ['title' => 'Security Guard', 'code' => 'SG'],
            ['title' => 'First Aid Officer', 'code' => 'FAO'],
            ['title' => 'Workplace Health & Safety Representative', 'code' => 'WHSR'],
        ];

        foreach ($roles as $index => $roleData) {

            $upperCaseCode = strtoupper($roleData['code']);

            Role::updateOrCreate(
                ['code' => $upperCaseCode],
                [
                    'title' => $roleData['title'],
                    'code' => $upperCaseCode,
                    'del' => '0',
                    // First 9 records → is_seeded = 1, others = 0
                    'is_seeded' => $index < 9 ? 1 : 0 
                ]
            );
        }

        echo "Roles seeded successfully. Total: " . count($roles) . "\n";
    }
}

