<?php

namespace Database\Seeders;

use App\Models\Trade;
use Illuminate\Database\Seeder;

class TradeSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $trades = [
            'General Construction',
            'Carpentry',
            'Electrical',
            'Plumbing',
            'HVAC (Heating, Ventilation & Air Conditioning)',
            'Roofing',
            'Concrete & Masonry',
            'Steel Fabrication & Erection',
            'Painting & Decorating',
            'Plastering & Drywall',
            'Tiling',
            'Flooring',
            'Glazing & Windows',
            'Insulation',
            'Scaffolding',
            'Excavation & Earthworks',
            'Landscaping',
            'Fencing',
            'Asphalt & Paving',
            'Demolition',
            'Fire Protection',
            'Security Systems',
            'Elevator Installation',
            'Kitchen & Bathroom Installation',
            'Joinery',
            'Metalwork',
            'Welding',
            'Bricklaying',
            'Stonemasonry',
            'Waterproofing',
            'Structural Steel',
            'Reinforcement',
            'Formwork',
            'Crane & Lifting Services',
            'Traffic Management',
            'Environmental Services',
            'Waste Management',
            'Site Cleaning',
            'Safety & Compliance',
            'Project Management',
            'Quantity Surveying',
            'Architectural Services',
            'Engineering Services',
            'Surveying',
            'Testing & Commissioning',
            'Maintenance Services',
        ];

        foreach ($trades as $index => $title) {
            Trade::updateOrCreate(
                ['title' => $title],
                [
                    'title' => $title,
                    'del' => '0'
                ]
            );
        }

        echo "Trades seeded successfully. Total: " . count($trades) . "\n";
    }
}

