@php
  use Illuminate\Support\Facades\DB;
  use App\Models\User;
  

  $customer_id = $customer_id ?? null;
  $logoPath = null;
  $companyName = env('APP_NAME', 'WMS');
  $companyAddress = '';
  $companyCity = '';
  $companyState = '';
  $companyPostCode = '';
  $companyCountry = '';
  $companyPhone = 'Contact Information';
  $companyEmail = env('EMAIL_ADDRESS', 'support@example.com');
  
  // Get admin settings data
    $admin = User::where('user_type', config('constants.user_types.admin'))->first();
    if ($admin) {
      $settings = DB::table('adminsettings')
          ->where('customer_id', $admin->id)
          ->get();
          
      // Transform into key-value pairs for easier access
      $settingsData = [];
      foreach ($settings as $setting) {
          $settingsData[$setting->key] = $setting->value;
      }
      
      // Get logo
      if (isset($settingsData['brand_logo_dark'])) {
          $logoPath = $settingsData['brand_logo_dark'];
      }
      
      // Get company information
      if (isset($settingsData['company_company_name'])) {
          $companyName = $settingsData['company_company_name'];
      }
      if (isset($settingsData['company_company_address'])) {
          $companyAddress = $settingsData['company_company_address'];
      }
      
      if (isset($settingsData['company_company_city'])) {
          $companyCity = $settingsData['company_company_city'];
      }
      
      if (isset($settingsData['company_company_state'])) {
          $companyState = $settingsData['company_company_state'];
      }
      
      if (isset($settingsData['company_company_post_code'])) {
          $companyPostCode = $settingsData['company_company_post_code'];
      }
      
      if (isset($settingsData['company_company_country'])) {
          $companyCountry = $settingsData['company_company_country'];
      }
      
      if (isset($settingsData['company_company_telephone'])) {
          $companyPhone = $settingsData['company_company_telephone'];
      }
      
      if (isset($settingsData['company_company_email'])) {
          $companyEmail = $settingsData['company_company_email'];
      }
    }
  
  
  // Format full address
  $fullAddress = $companyAddress;
  if (!empty($companyCity)) {
      $fullAddress .= ', ' . $companyCity;
  }
  if (!empty($companyState)) {
      $fullAddress .= ', ' . $companyState;
  }
  if (!empty($companyPostCode)) {
      $fullAddress .= ' ' . $companyPostCode;
  }
  if (!empty($companyCountry)) {
      $fullAddress .= ', ' . $companyCountry;
  }
  

  // Define color theme based on account status
  if ($status == 'enabled') {
    $themeColor = '#22C55E'; // Green
    $themeBackground = 'linear-gradient(135deg, #D1FAE5 0%, #A7F3D0 100%)';
    $themeIcon = '✅';
    $message = 'Your account has been activated. You can now log in using your credentials.';
  } else {
    $themeColor = '#EF4444'; // Red
    $themeBackground = 'linear-gradient(135deg, #FEE2E2 0%, #FECACA 100%)';
    $themeIcon = '🔒';
    $message = 'Your account access has been temporarily disabled. You cannot log in at this time.';
  }


  
  // Get logo path if available
@endphp


<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>{{ $subject }}</title>
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@100;200;300;400;500;600;700;800;900&display=swap" rel="stylesheet">

  @include('Emails.partial.admin-style')
 
</head>
<body>
  <div class="email-template">
  @include('Emails.partial.header', ['logoPath' => $logoPath])
    <div class="email-body">
      <div class="email-body-box-one">
          <div class="email-body-icon-one">
            <img src="{{ url('assets/img/Symbol.png') }}" >
          </div>
          <h2>Account Status Notification</h2>
          <p class="email-body-box-one-first-p">Your Account Has Been {{ ucfirst($status) }}</p>
      </div>
      <div class="email-body-box-two">
        <div class="email-body-main-text">
          <p>
            Hi <span>{{ $name }}</span>,
            <br/><br/>
            {{ $message }}
            <br/><br/>
            <strong>Email:</strong> {{ $email }}<br/>
            <strong>Status:</strong> <span style="color: {{ $themeColor }};padding: 5px 10px;border-radius: 5px;background-color: {{ $themeBackground }};">{{ ucfirst($status) }}</span>
          </p>
        </div>
        @if($status == 'enabled')
        <a href="{{ env('FRONTEND_URL') }}" class="email-body-button">Login to Your Account</a>
        @endif
        <p class="email-body-thankyou-text">
        @if($status == 'enabled')
          Your account has been enabled by an administrator. You can now access all features and services available to your account.
          <br/><br/>
          If you have any questions about your account or need assistance, our support team is here to help.
        @else
          Your account access has been temporarily disabled by an administrator. During this time, you will not be able to log in to the system or access any services.
          <br/><br/>
          If you believe this is an error or have questions about why your account was disabled, please contact our support team for assistance.
        @endif
          <br/><br/>
          Thank you,<br/>
          {{ $companyName }} Team
        </p>
      </div>
    </div>
    @include('Emails.partial.admin-footer')
  </div>

</body>
</html>