@php
  use App\General\SettingsClass;
  use Illuminate\Support\Facades\DB;
  use App\Models\User;
  

  $logoPath = null;
  $companyName = env('APP_NAME', 'WMS');
  $companyAddress = '';
  $companyCity = '';
  $companyState = '';
  $companyPostCode = '';
  $companyCountry = '';
  $companyPhone = 'Contact Information';
  $companyEmail = env('EMAIL_ADDRESS', 'support@example.com');
  
  // Get admin settings data
    $admin = User::where('user_type', config('constants.user_types.admin'))->first();
    if ($admin) {
      $settings = DB::table('adminsettings')
          ->where('customer_id', $admin->id)
          ->get();
          
      // Transform into key-value pairs for easier access
      $settingsData = [];
      foreach ($settings as $setting) {
          $settingsData[$setting->key] = $setting->value;
      }
      
      // Get logo
      if (isset($settingsData['brand_logo_dark'])) {
          $logoPath = $settingsData['brand_logo_dark'];
      }
      
      // Get company information
      if (isset($settingsData['company_company_name'])) {
          $companyName = $settingsData['company_company_name'];
      }
      if (isset($settingsData['company_company_address'])) {
          $companyAddress = $settingsData['company_company_address'];
      }
      
      if (isset($settingsData['company_company_city'])) {
          $companyCity = $settingsData['company_company_city'];
      }
      
      if (isset($settingsData['company_company_state'])) {
          $companyState = $settingsData['company_company_state'];
      }
      
      if (isset($settingsData['company_company_post_code'])) {
          $companyPostCode = $settingsData['company_company_post_code'];
      }
      
      if (isset($settingsData['company_company_country'])) {
          $companyCountry = $settingsData['company_company_country'];
      }
      
      if (isset($settingsData['company_company_telephone'])) {
          $companyPhone = $settingsData['company_company_telephone'];
      }
      
      if (isset($settingsData['company_company_email'])) {
          $companyEmail = $settingsData['company_company_email'];
      }
    }
  
  
  // Format full address
  $fullAddress = $companyAddress;
  if (!empty($companyCity)) {
      $fullAddress .= ', ' . $companyCity;
  }
  if (!empty($companyState)) {
      $fullAddress .= ', ' . $companyState;
  }
  if (!empty($companyPostCode)) {
      $fullAddress .= ' ' . $companyPostCode;
  }
  if (!empty($companyCountry)) {
      $fullAddress .= ', ' . $companyCountry;
  } 
  
  // Status configuration defaults in case they're not provided
  if (!isset($status_config)) {
    $status_config = [
      'subject' => $subject ?? 'Payment Notification',
      'status_text' => 'Unknown',
      'color' => '#6B7280', // Gray
      'background' => 'linear-gradient(135deg, #F3F4F6 0%, #E5E7EB 100%)',
      'icon' => '📄',
      'message' => 'Payment status information.',
      'action_required' => false,
      'action_message' => ''
    ];
  }
@endphp

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>{{ $subject }}</title>
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@100;200;300;400;500;600;700;800;900&display=swap" rel="stylesheet">

  @include('Emails.partial.admin-style')
 
</head>
<body>
  <div class="email-template">
  @include('Emails.partial.header', ['logoPath' => $logoPath])
    <div class="email-body">
      <div class="email-body-box-one">
          <div class="email-body-icon-one">
            @php
              $statusText = strtolower($status_config['status_text'] ?? '');
              if ($statusText === 'rejected') {
                $iconImage = 'Symbol-6.png';
              } elseif ($statusText === 'successful' || $statusText === 'success') {
                $iconImage = 'Symbol-4.png';
              } elseif ($statusText === 'pending') {
                $iconImage = 'Symbol-5.png';
              } else {
                $iconImage = 'Symbol.png'; // default image
              }
            @endphp
            <img src="{{ url('assets/img/' . $iconImage) }}" alt="Payment Status Icon">
          </div>
          <h2>Payment {{ $status_config['status_text'] }}</h2>
          <p class="email-body-box-one-first-p">
            @if (strtolower($status_config['status_text']) === 'rejected')
              Payment has been rejected.
            @elseif (strtolower($status_config['status_text']) === 'successful' || strtolower($status_config['status_text']) === 'success')
              Payment received from customer.
            @elseif (strtolower($status_config['status_text']) === 'pending')
              Payment is pending review.
            @elseif (strtolower($status_config['status_text']) === 'failed')
              Payment has failed.
            @elseif (strtolower($status_config['status_text']) === 'refunded')
              Payment has been refunded.
            @else
              Payment notification from customer.
            @endif
          </p>
      </div>
      <div class="email-body-box-two">
        <div class="email-body-main-text">
          <p>
            Hi <span>Admin</span>,
            <br/><br/>
            {{ $status_config['message'] }}
          </p>
        </div>
        <div class="email-body-details-box">
          <h3>
           Customer Information
          </h3>
          <table>
            <tr>
              <td>Name</td>
              <td style="text-align: end;">
              {{ $customer_name }}
              </td>
            </tr>
            <tr>
              <td style="border-bottom: none;padding-bottom:0px;">Email</td>
              <td style="text-align: end;border-bottom: none;padding-bottom: 0px;">
              {{ $customer_email }}
              </td>
            </tr>
          </table>
          <h3 style="margin-top:20px;">
            Order Details
          </h3>
          <table>
            <tr>
              <td>Order ID</td>
              <td style="text-align: end;">
              {{$order_id}}
              </td>
            </tr>
            <tr>
              <td>Plan</td>
              <td style="text-align: end;">
              {{ $plan_name }}
              </td>
            </tr>
            <tr>
              <td>Amount</td>
              <td style="text-align: end;">
              {{ $price }} {{ $currency }}
              </td>
            </tr>
            <tr>
              <td>Payment Type</td>
              <td style="text-align: end;">
              {{ $payment_type }}
              </td>
            </tr>
            <tr>
              <td>Status</td>
              <td style="text-align: end;">
              {{ $status_config['status_text'] }}
              </td>
            </tr>
            <tr>
              <td>Recurring</td>
              <td style="text-align: end;">
              {{ $is_recurring }}
              </td>
            </tr>
            <tr>
              <td>Period</td>
              <td style="text-align: end;">
              {{ $interval }} Month(s)
              </td>
            </tr>
            <tr>
              <td style="border-bottom: none;padding-bottom:0px;">Date</td>
              <td style="text-align: end;border-bottom: none;padding-bottom: 0px;">
              {{ $date }}
              </td>
            </tr>
          </table>
        </div>
        <p class="email-body-thankyou-text">
        @php
          $statusTexts = [
            0 => 'This payment request requires your review and approval through the admin dashboard. Please verify the payment before approving the request.',
            1 => 'This payment has been automatically processed and the customer\'s account has been updated successfully. The customer has been notified via email.',
            2 => 'This payment has failed. You may need to contact the customer to arrange an alternative payment method.',
            3 => 'This payment has been refunded to the customer. The subscription or plan access may have been revoked.',
            4 => 'This payment request has been rejected. No further action is required.'
          ];
          
          $statusText = $statusTexts[$payment_status] ?? $statusTexts[0];
        @endphp
        {{ $statusText }}
        <br/><br/>
        @if($status_config['action_required'])
          Once processed, the customer will receive an appropriate confirmation email based on your action.
        @else
          No further action is required from your end.
        @endif
        </p>
      </div>
    </div>
    @include('Emails.partial.admin-footer')
  </div>

</body>
</html>