@php
  use App\General\SettingsClass;
  use Illuminate\Support\Facades\DB;
  use App\Models\User;
  

  $logoPath = null;
  $companyName = env('APP_NAME', 'WMS');
  $companyAddress = '';
  $companyCity = '';
  $companyState = '';
  $companyPostCode = '';
  $companyCountry = '';
  $companyPhone = 'Contact Information';
  $companyEmail = env('EMAIL_ADDRESS', 'support@example.com');
  
  // Get admin settings data
    $admin = User::where('user_type', config('constants.user_types.admin'))->first();
    if ($admin) {
      $settings = DB::table('adminsettings')
          ->where('customer_id', $admin->id)
          ->get();
          
      // Transform into key-value pairs for easier access
      $settingsData = [];
      foreach ($settings as $setting) {
          $settingsData[$setting->key] = $setting->value;
      }
      
      // Get logo
      if (isset($settingsData['brand_logo_dark'])) {
          $logoPath = $settingsData['brand_logo_dark'];
      }
      
      // Get company information
      if (isset($settingsData['company_company_name'])) {
          $companyName = $settingsData['company_company_name'];
      }
      if (isset($settingsData['company_company_address'])) {
          $companyAddress = $settingsData['company_company_address'];
      }
      
      if (isset($settingsData['company_company_city'])) {
          $companyCity = $settingsData['company_company_city'];
      }
      
      if (isset($settingsData['company_company_state'])) {
          $companyState = $settingsData['company_company_state'];
      }
      
      if (isset($settingsData['company_company_post_code'])) {
          $companyPostCode = $settingsData['company_company_post_code'];
      }
      
      if (isset($settingsData['company_company_country'])) {
          $companyCountry = $settingsData['company_company_country'];
      }
      
      if (isset($settingsData['company_company_telephone'])) {
          $companyPhone = $settingsData['company_company_telephone'];
      }
      
      if (isset($settingsData['company_company_email'])) {
          $companyEmail = $settingsData['company_company_email'];
      }
    }
  
  
  // Format full address
  $fullAddress = $companyAddress;
  if (!empty($companyCity)) {
      $fullAddress .= ', ' . $companyCity;
  }
  if (!empty($companyState)) {
      $fullAddress .= ', ' . $companyState;
  }
  if (!empty($companyPostCode)) {
      $fullAddress .= ' ' . $companyPostCode;
  }
  if (!empty($companyCountry)) {
      $fullAddress .= ', ' . $companyCountry;
  }

  // Define color theme for this email
  $themeColor = '#F59E0B'; // Orange
  $themeBackground = 'linear-gradient(135deg, #FFEDD5 0%, #FED7AA 100%)';
  $themeIcon = '🏦';

@endphp

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>{{ $subject }}</title>
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@100;200;300;400;500;600;700;800;900&display=swap" rel="stylesheet">

  @include('Emails.partial.admin-style')
 
</head>
<body>
  <div class="email-template">
  @include('Emails.partial.header', ['logoPath' => $logoPath])
    <div class="email-body">
      <div class="email-body-box-one">
          <div class="email-body-icon-one" style="background-color: #F59E0B !important;">
            <img src="{{ url('assets/img/Symbol-5.png') }}" >
          </div>
          <h2>Bank Transfer Request</h2>
          <p class="email-body-box-one-first-p">Your bank transfer request is pending approval.</p>
      </div>
      <div class="email-body-box-two">
        <div class="email-body-main-text">
          <p>
            Hi <span>{{ $name }}</span>,
            <br/><br/>
            Your bank transfer request has been received and is currently pending approval. Our team will review your request and confirm your payment shortly.
          </p>
        </div>
        <div class="email-body-details-box">
          <h3>
           Order Information
          </h3>
          <table>
            <tr>
              <td>Order ID</td>
              <td style="text-align: end;">
              {{$order_id}}
              </td>
            </tr>
            <tr>
              <td>Plan</td>
              <td style="text-align: end;">
              {{ $plan_name }}
              </td>
            </tr>
            <tr>
              <td>Amount</td>
              <td style="text-align: end;">
              {{ $price }} {{ $currency }}
              </td>
            </tr>
            <tr>
              <td>Period</td>
              <td style="text-align: end;">
              {{ $interval }} Month(s)
              </td>
            </tr>
            <tr>
              <td style="border-bottom: none;padding-bottom:0px;">Stauts</td>
              <td style="text-align: end;border-bottom: none;padding-bottom: 0px;color: #F59E0B;">
              Pending
              </td>
            </tr>
          </table>
        </div>
        <p class="email-body-thankyou-text">
        Once your payment is confirmed, your account will be activated, and you'll receive a confirmation email. This usually takes 1-2 business days.
        <br/><br/>
        If you have any questions about your order or need assistance with the payment process, please contact our customer support team.
        <br/><br/>
        Thank you,<br/>
          {{ $companyName }} Team
        </p>
      </div>
    </div>
    @include('Emails.partial.admin-footer')
  </div>

</body>
</html>