@php
  use Illuminate\Support\Facades\DB;
  use App\Models\User;
  
    // Default values
  $logoPath = null;
  $companyName = env('APP_NAME', 'WMS');
  $companyAddress = '';
  $companyCity = '';
  $companyState = '';
  $companyPostCode = '';
  $companyCountry = '';
  $companyPhone = 'Contact Information';
  $companyEmail = env('EMAIL_ADDRESS', 'support@example.com');
  
  // Get admin settings data
    $admin = User::where('user_type', config('constants.user_types.admin'))->first();
    if ($admin) {
      $settings = DB::table('adminsettings')
          ->where('customer_id', $admin->id)
          ->get();
          
      // Transform into key-value pairs for easier access
      $settingsData = [];
      foreach ($settings as $setting) {
          $settingsData[$setting->key] = $setting->value;
      }
      
      // Get logo
      if (isset($settingsData['brand_logo_dark'])) {
          $logoPath = $settingsData['brand_logo_dark'];
      }
      
      // Get company information
      if (isset($settingsData['company_company_name'])) {
          $companyName = $settingsData['company_company_name'];
      }
      if (isset($settingsData['company_company_address'])) {
          $companyAddress = $settingsData['company_company_address'];
      }
      
      if (isset($settingsData['company_company_city'])) {
          $companyCity = $settingsData['company_company_city'];
      }
      
      if (isset($settingsData['company_company_state'])) {
          $companyState = $settingsData['company_company_state'];
      }
      
      if (isset($settingsData['company_company_post_code'])) {
          $companyPostCode = $settingsData['company_company_post_code'];
      }
      
      if (isset($settingsData['company_company_country'])) {
          $companyCountry = $settingsData['company_company_country'];
      }
      
      if (isset($settingsData['company_company_telephone'])) {
          $companyPhone = $settingsData['company_company_telephone'];
      }
      
      if (isset($settingsData['company_company_email'])) {
          $companyEmail = $settingsData['company_company_email'];
      }
    }
  
  
  // Format full address
  $fullAddress = $companyAddress;
  if (!empty($companyCity)) {
      $fullAddress .= ', ' . $companyCity;
  }
  if (!empty($companyState)) {
      $fullAddress .= ', ' . $companyState;
  }
  if (!empty($companyPostCode)) {
      $fullAddress .= ' ' . $companyPostCode;
  }
  if (!empty($companyCountry)) {
      $fullAddress .= ', ' . $companyCountry;
  }
  
  // Determine if this is for admin or user
  $isAdminEmail = isset($is_admin_notification) && $is_admin_notification;
@endphp
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>{{ $subject }}</title>
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@100;200;300;400;500;600;700;800;900&display=swap" rel="stylesheet">

  @include('Emails.partial.admin-style')
 
</head>
<body>
  <div class="email-template">
  @include('Emails.partial.header', ['logoPath' => $logoPath])
    <div class="email-body">
    @if($isAdminEmail)
    <div class="email-body-box-one">
          <div class="email-body-icon-one">
            <img src="{{ url('assets/img/Symbol.png') }}" >
          </div>
          <h2>New Contact Form Submission</h2>
          <p class="email-body-box-one-first-p">A new form has been submitted</p>
      </div>
      <div class="email-body-box-two">
        <div class="email-body-main-text">
          <p>
            Hi <span>Admin</span>,
            <br/><br/>
            A new contact form has been submitted through your website. Please review the details below and respond promptly.
          </p>
        </div>
        <div class="email-body-details-box">
          <h3>
            Contact Details
          </h3>
          <table>
            <tr>
              <td>Name</td>
              <td style="text-align: end;">
              {{ $first_name }} {{ $last_name }}
              </td>
            </tr>
            <tr>
              <td>Email</td>
              <td style="text-align: end;">
                {{ $email }}
              </td>
            </tr>
            <tr>
              <td >Phone</td>
              <td style="text-align: end;">
              {{ $phone_number }}
              </td>
            </tr>
            <tr>
              <td>Submitted</td>
              <td style="text-align: end;">
              {{ $submitted_at ?? now()->format('M d, Y \a\t g:i A') }}
              </td>
            </tr>
            <tr>
              <td colspan="2" style="border-bottom: none;padding-bottom:0px;">Message</td>
            </tr>
            <tr>
              <td colspan="2" style="border-bottom: none;padding-bottom:0px;">{{ $message }}</td>
            </tr>
          </table>
        </div>
        <div class="email-alert-box">
          <table>
            <tr>
              <td style="width: 50px;vertical-align: baseline;text-align: start;">
                <img src="{{ url('assets/img/alert-icon.png') }}" alt="">
              </td>
              <td>
                <h3>Action Required</h3>
                <p>Please respond to this customer inquiry within 24-48 hours to maintain good customer service standards</p>
              </td>
            </tr>
          </table>
        </div>
        <p class="email-body-thankyou-text">
        This contact form submission has been automatically logged in your system for tracking and follow-up purposes.
          <br/><br/>
          Best regards,<br/>
          {{ $companyName }} Contact System
        </p>
      </div>
    @else
      <div class="email-body-box-one">
          <div class="email-body-icon-one">
            <img src="{{ url('assets/img/Symbol.png') }}" >
          </div>
          <h2>Contact Us</h2>
          <p class="email-body-box-one-first-p">Thank you for contacting us.</p>
      </div>
      <div class="email-body-box-two">
        <div class="email-body-main-text">
          <p>
            Hi <span>{{ $first_name }}</span>,
            <br/><br/>
            Thank you for reaching out to us! We have successfully received your contact form submission and our team will review it carefully.
          </p>
        </div>
        <div class="email-body-details-box">
          <h3>
            Contact Details
          </h3>
          <table>
            <tr>
              <td>Name</td>
              <td style="text-align: end;">
              {{ $first_name }} {{ $last_name }}
              </td>
            </tr>
            <tr>
              <td>Email</td>
              <td style="text-align: end;">
                {{ $email }}
              </td>
            </tr>
            <tr>
              <td >Phone</td>
              <td style="text-align: end;">
              {{ $phone_number }}
              </td>
            </tr>
            <tr>
              <td>Submitted</td>
              <td style="text-align: end;">
              {{ $submitted_at ?? now()->format('M d, Y \a\t g:i A') }}
              </td>
            </tr>
            <tr>
              <td colspan="2" style="border-bottom: none;padding-bottom:0px;">Message</td>
            </tr>
            <tr>
              <td colspan="2" style="border-bottom: none;padding-bottom:0px;">{{ $message }}</td>
            </tr>
          </table>
        </div>
        <div class="email-alert-box">
          <table>
            <tr>
              <td style="width: 50px;vertical-align: baseline;text-align: start;">
                <img src="{{ url('assets/img/alert-icon.png') }}" alt="">
              </td>
              <td>
                <h3>Response Time</h3>
                <p>We typically respond within 24-48 hours during business days.</p>
              </td>
            </tr>
          </table>
        </div>
        <p class="email-body-thankyou-text">
        Our dedicated customer support team has been notified about your inquiry and will get back to you as soon as possible. We appreciate your interest in {{ $companyName }} and look forward to assisting you.<br/><br/>
        If you need to add any additional information to your inquiry, please feel free to reply to this email or submit a new contact form on our website.
          <br/><br/>
          Thank you for choosing {{ $companyName }}<br/>
          Customer Support Team
        </p>
      </div>
      @endif
    </div>
    @include('Emails.partial.admin-footer')
  </div>

</body>
</html>