@php
    use App\Services\CompanyEmailDetails;

    $companyDetails = CompanyEmailDetails::getCompanyEmailDetails($customer_id ?? null);
    $logoPath = $companyDetails['logoPath'];
    $companyName = $companyDetails['companyName'];
    $companyAddress = $companyDetails['companyAddress'];
    $companyCity = $companyDetails['companyCity'];
    $companyState = $companyDetails['companyState'];
    $companyPostCode = $companyDetails['companyPostCode'];
    $companyCountry = $companyDetails['companyCountry'];
    $companyPhone = $companyDetails['companyPhone'];
    $companyEmail = $companyDetails['companyEmail'];
    $fullAddress =
        $companyDetails['companyAddressFull'] ??
        trim(
            ($companyAddress ?? '') .
                ', ' .
                ($companyCity ?? '') .
                ', ' .
                ($companyState ?? '') .
                ', ' .
                ($companyPostCode ?? '') .
                ', ' .
                ($companyCountry ?? ''),
        );
@endphp
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>{{ $subject }}</title>
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@100;200;300;400;500;600;700;800;900&display=swap" rel="stylesheet">
  @php
    \Illuminate\Support\Facades\Log::info('OTP Email Template: Before including style partial', [
      'customer_id' => $customer_id ?? 'NULL',
      'email' => $email ?? 'NULL',
      'template_path' => 'Emails.defect-creator'
    ]);
    
    // Check if the partial file exists
    $stylePartialPath = resource_path('views/Emails/partial/style.blade.php');
    $stylePartialExists = file_exists($stylePartialPath);
    \Illuminate\Support\Facades\Log::info('OTP Email Template: Style partial file check', [
      'path' => $stylePartialPath,
      'exists' => $stylePartialExists,
      'readable' => $stylePartialExists ? is_readable($stylePartialPath) : false
    ]);
  @endphp
  @include('Emails.partial.style', ['customer_id' => $customer_id])
  @php
    \Illuminate\Support\Facades\Log::info('OTP Email Template: After including style partial');
  @endphp
</head>
<body>
  <div class="email-template">
    @include('Emails.partial.header', ['logoPath' => $logoPath])
    <div class="email-body">
      <div class="email-body-box-one">
          <div class="email-body-icon-one">
            <img src="{{ url('assets/img/Symbol-3.png') }}" >
          </div>
          <h2>Defect Assignment</h2>
          <p class="email-body-box-one-first-p">You have been assigned a defect.</p>
      </div>
      <div class="email-body-box-two">
        <div class="email-body-main-text">
          <p>
            Hi <span>{{ $creator_name }}</span>,
            <br/><br/>
            There is an update on your defect/task. See the details below:
          </p>
        </div>
        <div class="email-body-details-box">
          <h3>
            Defect Details
          </h3>
          <table>
            <tr>
              <td>Title</td>
              <td style="text-align: end;">
                {{ $defect_title }}
              </td>
            </tr>
            <tr>
              <td>Current Status</td>
              <td style="text-align: end;">
                {{ $defect_status_label }}
              </td>
            </tr>
            <tr>
              <td>Priority</td>
              <td style="text-align: end;">
                {{ $defect_priority }}
              </td>
            </tr>
            @if (!empty($defect_due_date))
            <tr>
              <td>Due Date</td>
              <td style="text-align: end;">
                {{ $defect_due_date }}
              </td>
            </tr>
            @endif
            @if (!empty($reject_reason))
            <tr>
              <td colspan="2" style="border-bottom: none;padding-bottom:0px;">Reject Reason</td>
            </tr>
            <tr>
              <td colspan="2" style="border-bottom: none;padding-bottom:0px;">{{ $reject_reason }}</td>
            </tr>
            @endif
            @if (!empty($completion_description))
            <tr>
              <td colspan="2" style="border-bottom: none;padding-bottom:0px;">Completion Description</td>
            </tr>
            <tr>
              <td colspan="2" style="border-bottom: none;padding-bottom:0px;">{{ $completion_description }}</td>
            </tr>
            @endif
          </table>
          </div>
          <a href="{{ $action_url }}" target="_blank" class="email-body-button">Open in portal</a>
      </div>
    </div>
   
   
    @include('Emails.partial.customer-footer', [
      'logoPath' => $logoPath,
      'fullAddress' => $fullAddress,
      'companyPhone' => $companyPhone,
      'companyEmail' => $companyEmail
    ])
  </div>
  @include('Emails.partial.admin-footer')
</body>
</html>
