@php
    use App\General\SettingsClass;
    use Illuminate\Support\Facades\DB;
    use App\Models\User;
    use App\Models\Adminsettings;

    $logoPath = null;
    $companyName = env('APP_NAME', 'WMS');
    $companyAddress = '';
    $companyCity = '';
    $companyState = '';
    $companyPostCode = '';
    $companyCountry = '';
    $companyPhone = 'Contact Information';
    $companyEmail = env('EMAIL_ADDRESS', 'support@example.com');

    // Get admin settings data
    $admin = User::where('user_type', config('constants.user_types.admin'))->first();
    if ($admin) {
        $settings = DB::table('adminsettings')->where('customer_id', $admin->id)->get();

        // Transform into key-value pairs for easier access
        $settingsData = [];
        foreach ($settings as $setting) {
            $settingsData[$setting->key] = $setting->value;
        }

        // Get logo
        if (isset($settingsData['brand_logo_dark'])) {
            $logoPath = $settingsData['brand_logo_dark'];
        }

        // Get company information
        if (isset($settingsData['company_company_name'])) {
            $companyName = $settingsData['company_company_name'];
        }
        if (isset($settingsData['company_company_address'])) {
            $companyAddress = $settingsData['company_company_address'];
        }

        if (isset($settingsData['company_company_city'])) {
            $companyCity = $settingsData['company_company_city'];
        }

        if (isset($settingsData['company_company_state'])) {
            $companyState = $settingsData['company_company_state'];
        }

        if (isset($settingsData['company_company_post_code'])) {
            $companyPostCode = $settingsData['company_company_post_code'];
        }

        if (isset($settingsData['company_company_country'])) {
            $companyCountry = $settingsData['company_company_country'];
        }

        if (isset($settingsData['company_company_telephone'])) {
            $companyPhone = $settingsData['company_company_telephone'];
        }

        if (isset($settingsData['company_company_email'])) {
            $companyEmail = $settingsData['company_company_email'];
        }
    }

    // Get system date and time format settings
    $systemDateFormat = 'd-m-Y'; // Default format
    $systemTimeFormat = 'H:i'; // Default 24-hour format

    if ($admin) {
        $dateSetting = Adminsettings::where('customer_id', $admin->id)->where('key', 'system_date_format')->first();

        $timeSetting = Adminsettings::where('customer_id', $admin->id)->where('key', 'system_time_format')->first();

        if ($dateSetting && $dateSetting->value) {
            // Convert system format to Carbon format
            $formatMap = [
                'mm-dd-yyyy' => 'm-d-Y',
                'dd-mm-yyyy' => 'd-m-Y',
                'yyyy-mm-dd' => 'Y-m-d',
                'mm/dd/yyyy' => 'm/d/Y',
                'dd/mm/yyyy' => 'd/m/Y',
                'yyyy/mm/dd' => 'Y/m/d',
            ];
            $systemDateFormat = $formatMap[strtolower($dateSetting->value)] ?? 'd-m-Y';
        }

        if ($timeSetting && $timeSetting->value) {
            // Check if the format contains AM/PM or if user prefers 12-hour format
            $value = strtoupper($timeSetting->value);
            if (
                str_contains($value, 'AM') ||
                str_contains($value, 'PM') ||
                str_contains($value, '12') ||
                str_contains($value, 'HOUR')
            ) {
                $systemTimeFormat = 'g:i A'; // 12-hour format with AM/PM
            }
        }
    }

    // Format full address
    $fullAddress = $companyAddress;
    if (!empty($companyCity)) {
        $fullAddress .= ', ' . $companyCity;
    }
    if (!empty($companyState)) {
        $fullAddress .= ', ' . $companyState;
    }
    if (!empty($companyPostCode)) {
        $fullAddress .= ' ' . $companyPostCode;
    }
    if (!empty($companyCountry)) {
        $fullAddress .= ', ' . $companyCountry;
    }
    // Set defaults for variables that might not be provided
    if (!isset($subject)) {
        $subject = 'Helpdesk Ticket Update';
    }

    // Default status configuration in case it's not provided
if (!isset($status_config)) {
    $status_config = [
        'status_text' => 'Unknown',
        'color' => '#6B7280', // Gray
        'background' => 'linear-gradient(135deg, #F3F4F6 0%, #E5E7EB 100%)',
        'icon' => 'ðŸ“„',
        'message' => 'Ticket status information.',
        ];
    }
@endphp

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>{{ $subject }}</title>
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@100;200;300;400;500;600;700;800;900&display=swap" rel="stylesheet">

  @include('Emails.partial.admin-style')
 
</head>
<body>
  <div class="email-template">
  @include('Emails.partial.header', ['logoPath' => $logoPath])
    <div class="email-body">
      <div class="email-body-box-one">
          <div class="email-body-icon-one">
          <img src="{{ url('assets/img/Symbol-4.png') }}" >
          </div>
          <h2>Helpdesk Ticket</h2>
          <p class="email-body-box-one-first-p">
            @if ($recipient == 'customer')
            @if (isset($adminCreated) && $adminCreated)
                New Support Ticket Created for You: {{ $status_config['status_text'] }}
            @else
                Your Ticket Update: {{ $status_config['status_text'] }}
            @endif
            @else
                New Support Ticket Update: {{ $status_config['status_text'] }}
            @endif
          </p>
      </div>
      <div class="email-body-box-two">
        <div class="email-body-main-text">
          <p>
            Hi <span>
                @if ($recipient == 'customer')
                    {{ $ticket->name }}
                @else
                    Admin Support Team
                @endif
            </span>,
            <br/><br/>
            @if ($recipient == 'customer')
                @if (isset($adminCreated) && $adminCreated)
                    Welcome! Our support team has created a ticket on your behalf to help
                    resolve your issue. Please review the details below and feel free to respond with any
                    additional information.
                @else
                    {{ $status_config['message'] }}
                @endif
                @else
                    This ticket requires your attention. A new reply has been added to ticket
                    {{ $ticket->ticket_id }}.
            @endif
          </p>
        </div>
        <div class="email-body-details-box">
          <h3>
           Ticket Information
          </h3>
          <table>
            <tr>
              <td>Ticket ID</td>
              <td style="text-align: end;">
              {{ $ticket->ticket_id }}
              </td>
            </tr>
            <tr>
              <td>Subject</td>
              <td style="text-align: end;">
              {{ $ticket->subject }}
              </td>
            </tr>
            <tr>
              <td>Category</td>
              <td style="text-align: end;">
              {{ $ticket->getRelation('category') ? $ticket->getRelation('category')->name : 'N/A' }}
              </td>
            </tr>
            <tr>
              <td>Status</td>
              <td style="text-align: end;">
              {{ $status_config['status_text'] }}
              </td>
            </tr>
            <tr>
              <td style="border-bottom: none;padding-bottom:0px;">Created</td>
              <td style="text-align: end;border-bottom: none;padding-bottom: 0px;">
                @if (isset($formattedTicket))
                    {{ $formattedTicket['created_at'] }}
                @else
                    {{ $ticket->created_at->format($systemDateFormat . ' ' . $systemTimeFormat) }}
                @endif
              </td>
            </tr>
          </table>
          @if ($recipient == 'admin')
          <h3 style="margin-top:20px;">
           Customer Information
          </h3>
          <table>
            <tr>
              <td>Name</td>
              <td style="text-align: end;">
              {{ $ticket->name }}
              </td>
            </tr>
            <tr>
              <td style="border-bottom: none;padding-bottom:0px;">Email</td>
              <td style="text-align: end;border-bottom: none;padding-bottom: 0px;">
                {{ $ticket->email }}
              </td>
            </tr>
          </table>
          @endif
        </div>

        @php
          $hasConversations = false;
          $conversationCount = 0;
          if (isset($conversations) && !empty($conversations)) {
            $hasConversations = true;
            $conversationCount = count($conversations);
          } elseif (isset($ticket->conversations) && $ticket->conversations->count() > 0) {
            $hasConversations = true;
            $conversationCount = $ticket->conversations->count();
          }
        @endphp

        @if ($hasConversations)
        <div class="email-body-details-box">
          <h3>Ticket Conversation</h3>
          <div style="max-height: 450px; overflow-y: auto; overflow-x: hidden;">
          @if (isset($conversations))
            @foreach ($conversations as $conversation)
              @php
                $isAdmin =
                  isset($conversation['sender_user']) &&
                  $conversation['sender_user']['user_type'] == config('constants.user_types.admin');
                $isCustomer =
                  isset($conversation['sender_user']) &&
                  $conversation['sender_user']['user_type'] == config('constants.user_types.customer');
                $badgeText = $isAdmin ? 'ADMIN' : 'CUSTOMER';
                $badgeBgColor = $isAdmin ? '#10b981' : '#6b7280';
                $messageBgColor = $isAdmin ? '#f0fdf4' : '#f9fafb';
              @endphp
              <table width="100%" cellpadding="0" cellspacing="0" border="0" style="margin-bottom: 15px; background-color: {{ $messageBgColor }}; border: 1px solid #e5e7eb; border-radius: 8px;">
                <tr>
                  <td style="padding: 15px;border-bottom: none !important;">
                    <table width="100%" cellpadding="0" cellspacing="0" border="0">
                      <tr>
                        <td style="padding: 0px;">
                          <table cellpadding="0" cellspacing="0" border="0" width="100%">
                            <tr>
                              <td style="font-weight: 600; color: #1f2937; font-size: 14px;border-bottom: none;padding:0px 0px 10px !important;">
                                {{ isset($conversation['sender_user']) ? $conversation['sender_user']['name'] : 'Unknown User' }}
                                <span style="margin-left: 8px; padding: 2px 8px; border-radius: 4px; font-size: 11px; font-weight: 600; text-transform: uppercase; background-color: {{ $badgeBgColor }}; color: #fff; display: inline-block;">{{ $badgeText }}</span>
                              </td>
                              <td align="right" style="font-size: 12px; color: #6b7280;border-bottom: none;padding:0px 0px 10px !important;">
                                {{ $conversation['created_at'] }}
                              </td>
                            </tr>
                          </table>
                        </td>
                      </tr>
                      <tr>
                        <td style="color: #374151; font-size: 14px; line-height: 1.6; word-wrap: break-word; padding: 5px 0px !important;border-top: none;">
                          {{ $conversation['descriptions'] }}
                        </td>
                      </tr>
                      @if (isset($conversation['attachments']) && $conversation['attachments'])
                        <tr>
                          <td style="padding-top: 10px; border-top: 1px solid #e5e7eb;">
                            <a href="{{ url($conversation['attachments']) }}" target="_blank" style="color: #1ABD4B; text-decoration: none; font-size: 13px;">
                              <span>📎</span> Preview Attachment
                            </a>
                          </td>
                        </tr>
                      @endif
                    </table>
                  </td>
                </tr>
              </table>
            @endforeach
          @else
            @foreach ($ticket->conversations->sortByDesc('created_at') as $conversation)
              @php
                $isAdmin =
                  $conversation->senderUser &&
                  $conversation->senderUser->user_type == config('constants.user_types.admin');
                $isCustomer =
                  $conversation->senderUser &&
                  $conversation->senderUser->user_type == config('constants.user_types.customer');
                $badgeText = $isAdmin ? 'ADMIN' : 'CUSTOMER';
                $badgeBgColor = $isAdmin ? '#10b981' : '#6b7280';
                $messageBgColor = $isAdmin ? '#f0fdf4' : '#f9fafb';
              @endphp
              <table width="100%" cellpadding="0" cellspacing="0" border="0" style="margin-bottom: 15px; background-color: {{ $messageBgColor }}; border: 1px solid #e5e7eb; border-radius: 8px;">
                <tr>
                  <td style="padding: 15px;border-bottom: none !important;">
                    <table width="100%" cellpadding="0" cellspacing="0" border="0">
                      <tr>
                        <td style="padding: 0px;">
                          <table cellpadding="0" cellspacing="0" border="0" width="100%">
                            <tr>
                              <td style="font-weight: 600; color: #1f2937; font-size: 14px;border-bottom: none;padding:0px 0px 10px !important;">
                                {{ $conversation->senderUser ? $conversation->senderUser->name : 'Unknown User' }}
                                <span style="margin-left: 8px; padding: 2px 8px; border-radius: 4px; font-size: 11px; font-weight: 600; text-transform: uppercase; background-color: {{ $badgeBgColor }}; color: #fff; display: inline-block;">{{ $badgeText }}</span>
                              </td>
                              <td align="right" style="font-size: 12px; color: #6b7280;border-bottom: none;padding:0px 0px 10px !important;">
                                {{ $conversation->created_at->format($systemDateFormat . ' ' . $systemTimeFormat) }}
                              </td>
                            </tr>
                          </table>
                        </td>
                      </tr>
                      <tr>
                        <td style="color: #374151; font-size: 14px; line-height: 1.6; word-wrap: break-word; padding: 5px 0px !important;border-top: none;">
                          {{ $conversation->descriptions }}
                        </td>
                      </tr>
                      @if ($conversation->attachments)
                        <tr>
                          <td style="padding-top: 10px; border-top: 1px solid #e5e7eb;">
                            <a href="{{ url($conversation->attachments) }}" target="_blank" style="color: #1ABD4B; text-decoration: none; font-size: 13px;">
                              <span>📎</span> Preview Attachment
                            </a>
                          </td>
                        </tr>
                      @endif
                    </table>
                  </td>
                </tr>
              </table>
            @endforeach
          @endif
          </div>
        </div>
        @endif

        <p class="email-body-thankyou-text">
            @if ($recipient == 'customer')
                You can view the full ticket details and respond by logging into your account.
            @else
                Please login to the admin panel to respond to this ticket.
            @endif
        </p>
      </div>
    </div>
    @include('Emails.partial.admin-footer')
  </div>

</body>
</html>