@php
    use App\Services\CompanyEmailDetails;

    // Get company details using global helper function
    $customer_id = $customer_id ?? null;
   $companyDetails = CompanyEmailDetails::getCompanyEmailDetails($customer_id);
    // Extract variables for easier use in template
    $logoPath = $companyDetails['logoPath'];
    $companyName = $companyDetails['companyName'];
    $companyAddress = $companyDetails['companyAddress'];
    $companyCity = $companyDetails['companyCity'];
    $companyState = $companyDetails['companyState'];
    $companyPostCode = $companyDetails['companyPostCode'];
    $companyCountry = $companyDetails['companyCountry'];
    $companyPhone = $companyDetails['companyPhone'];
    $companyEmail = $companyDetails['companyEmail'];
    $fullAddress = $companyDetails['companyAddressFull'];
@endphp

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>{{ $subject }}</title>
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@100;200;300;400;500;600;700;800;900&display=swap" rel="stylesheet">

  @include('Emails.partial.style', ['customer_id' => $customer_id])
 
</head>
<body>
  <div class="email-template">
  @include('Emails.partial.header', ['logoPath' => $logoPath])
    <div class="email-body">
      <div class="email-body-box-one">
          <div class="email-body-icon-one">
          <img src="{{ url('assets/img/Symbol-4.png') }}" >
          </div>
          <h2>Leave Request</h2>
          <p class="email-body-box-one-first-p">
            A new leave request has been submitted.
          </p>
      </div>
      <div class="email-body-box-two">
        <div class="email-body-main-text">
          <p>
            Hi <span>{{ $employeeName ?? 'Team Member' }}</span>,
            <br/><br/>
            A new leave request has been submitted. Please review the details below:
          </p>
        </div>
        <div class="email-body-details-box">
          <h3>
          Leave Details
          </h3>
          <table>
            <tr>
              <td>Employee Name</td>
              <td style="text-align: end;">
              {{ $employeeName ?? 'N/A' }}
              </td>
            </tr>
            <tr>
              <td>Leave Type</td>
              <td style="text-align: end;">
              {{ $leavePackageName ?? 'N/A' }}
              </td>
            </tr>
            <tr>
              <td>Start Date</td>
              <td style="text-align: end;">
              {{ $startDate ?? 'N/A' }}
              </td>
            </tr>
            <tr>
              <td>End Date</td>
              <td style="text-align: end;">
              {{ $endDate ?? 'N/A' }}
              </td>
            </tr>
            <tr>
              <td>Duration</td>
              <td style="text-align: end;">
              {{ $numberOfDays ?? 'N/A' }} day(s)
              </td>
            </tr>
            <tr>
              <td>Status</td>
              <td style="text-align: end;">
              Submitted for Approval
              </td>
            </tr>
            @if(isset($teamName) && $teamName)
            <tr>
              <td>Team</td>
              <td style="text-align: end;">
              {{ $teamName }}
              </td>
            </tr>
            @endif
            @if(isset($reason) && $reason)
            <tr>
              <td colspan="2" style="border-bottom: none;padding-bottom:0px;">Reason</td>
            </tr>
            <tr>
              <td colspan="2" style="border-bottom: none;padding-bottom:0px;">{{ $reason }}</td>
            </tr>
            @endif
          </table>
        </div>
        <div class="email-alert-box">
          <table>
            <tr>
              <td style="width: 50px;vertical-align: baseline;text-align: start;">
                <img src="{{ url('assets/img/alert-icon.png') }}" alt="">
              </td>
              <td>
                <h3>Important</h3>
                <p>This leave request requires approval from your supervisor. You will be notified once your request has been reviewed and a decision has been made. If you need to make any changes to this request, please contact your supervisor immediately.</p>
              </td>
            </tr>
          </table>
        </div>
        <p class="email-body-thankyou-text">
            @if($emailType === 'employee')
                Your leave request has been successfully submitted and is now pending approval from your supervisor.
                <br/><br/>
                Please ensure you have completed all necessary handover procedures and informed relevant team members about your planned absence.
                <br/><br/>
                You will receive another notification once your request has been reviewed. If you have any questions or need to make changes to this request, please contact your supervisor or HR department immediately.
            @elseif($emailType === 'supervisor')
                A leave request has been submitted by {{ $employeeName ?? 'an employee' }} and requires your review and approval.
                <br/><br/>
                Please review the leave details above and approve or reject this request through the system. Consider the team's workload and any planned projects during the requested period.
                <br/><br/>
                To take action on this request, please log into your dashboard or contact the employee directly if you need additional information.
            @elseif($emailType === 'cc')
                This is a notification that {{ $employeeName ?? 'an employee' }} has submitted a leave request for your information.
                <br/><br/>
                Please review the leave details above and plan accordingly for any team adjustments that may be needed during this period.
                <br/><br/>
                If you have any concerns about this leave request, please contact the supervisor or the employee directly.
            @else
                A leave request has been submitted by {{ $employeeName ?? 'an employee' }} for your information.
                <br/><br/>
                Please review the leave details above and take appropriate action if required.
            @endif
          <br/><br/>
          Best regards,<br/>
          {{ $companyName }} Team
        </p>
      </div>
    </div>
    @include('Emails.partial.customer-footer', [
      'logoPath' => $logoPath,
      'fullAddress' => $fullAddress,
      'companyPhone' => $companyPhone,
      'companyEmail' => $companyEmail
    ])
  </div>
  @include('Emails.partial.admin-footer')

</body>
</html>