@php
    use App\Services\CompanyEmailDetails;

    $companyDetails = CompanyEmailDetails::getCompanyEmailDetails($customer_id ?? null);
    $logoPath = $companyDetails['logoPath'];
    $companyName = $companyDetails['companyName'];
    $companyAddress = $companyDetails['companyAddress'];
    $companyCity = $companyDetails['companyCity'];
    $companyState = $companyDetails['companyState'];
    $companyPostCode = $companyDetails['companyPostCode'];
    $companyCountry = $companyDetails['companyCountry'];
    $companyPhone = $companyDetails['companyPhone'];
    $companyEmail = $companyDetails['companyEmail'];
    $fullAddress =
        $companyDetails['companyAddressFull'] ??
        trim(
            ($companyAddress ?? '') .
                ', ' .
                ($companyCity ?? '') .
                ', ' .
                ($companyState ?? '') .
                ', ' .
                ($companyPostCode ?? '') .
                ', ' .
                ($companyCountry ?? ''),
        );
@endphp

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>{{ $subject }}</title>
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@100;200;300;400;500;600;700;800;900&display=swap" rel="stylesheet">
  @include('Emails.partial.style', ['customer_id' => $customer_id])
</head>
<body>
  <div class="email-template">
    @include('Emails.partial.header', ['logoPath' => $logoPath])
    <div class="email-body">
      <div class="email-body-box-one">
          <div class="email-body-icon-one">
            <img src="{{ url('assets/img/Symbol-3.png') }}" >
          </div>
          <h2>Task Status Updated</h2>
          <p class="email-body-box-one-first-p">The status of your assigned task has been updated.</p>
      </div>
      <div class="email-body-box-two">
        <div class="email-body-main-text">
          <p>
            Hi <span>{{ $assignee_name }}</span>,
            <br/><br/>
            The status of your assigned task has been updated. See the details below:
          </p>
        </div>
        <div class="email-body-details-box">
          <h3>
            Status Update
          </h3>
          <table>
            <tr>
              <td>Task Title</td>
              <td style="text-align: end;">
                {{ $task_title }}
              </td>
            </tr>
            <tr>
              <td>Previous Status</td>
              <td style="text-align: end;">
                <span style="color: #666;">{{ $old_status_label }}</span>
              </td>
            </tr>
            <tr>
              <td>New Status</td>
              <td style="text-align: end;">
                <strong style="color: #007bff;">{{ $new_status_label }}</strong>
              </td>
            </tr>
            @if (!empty($completion_description))
            <tr>
              <td colspan="2" style="border-bottom: none;padding-bottom:0px;">Completion Description</td>
            </tr>
            <tr>
              <td colspan="2" style="border-bottom: none;padding-bottom:0px;">{{ $completion_description }}</td>
            </tr>
            @endif
            @if (!empty($reject_reason))
            <tr>
              <td colspan="2" style="border-bottom: none;padding-bottom:0px;">Reject Reason</td>
            </tr>
            <tr>
              <td colspan="2" style="border-bottom: none;padding-bottom:0px;">{{ $reject_reason }}</td>
            </tr>
            @endif
          </table>
        </div>
        <div class="email-body-details-box" style="margin-top: 20px;">
          <h3>
            Task Details
          </h3>
          <table>
            <tr>
              <td>Priority</td>
              <td style="text-align: end;">
                {{ $task_priority }}
              </td>
            </tr>
            <tr>
              <td>Due Date</td>
              <td style="text-align: end;">
                {{ $task_due_date }}
              </td>
            </tr>
            @if (!empty($project_name))
            <tr>
              <td>Project</td>
              <td style="text-align: end;">
                {{ $project_name }}
              </td>
            </tr>
            @endif
            @if (!empty($site_name))
            <tr>
              <td>Site</td>
              <td style="text-align: end;">
                {{ $site_name }}
              </td>
            </tr>
            @endif
            <tr>
              <td colspan="2" style="border-bottom: none;padding-bottom:0px;">Description</td>
            </tr>
            <tr>
              <td colspan="2" style="border-bottom: none;padding-bottom:0px;">{{ $task_description ?? "" }}</td>
            </tr>
          </table>
          </div>
          <br/>
        @if (env('APP_LINK_APPSTORE') || env('APP_LINK_APPSTORE_Apple'))
            <div class="app-download">
                <div style="display:flex;">
                    @if (env('APP_LINK_APPSTORE'))
                        <a class="store-card" href="{{ env('APP_LINK_APPSTORE') }}" target="_blank"
                            rel="noopener" style="margin-right: 10px; vertical-align: middle;">
                            <span class="store-badge">
                                <img src="https://play.google.com/intl/en_us/badges/static/images/badges/en_badge_web_generic.png"
                                    alt="Get it on Google Play"
                                    style="width: 150px; border: 0; display: block;">
                            </span>
                        </a>
                    @endif
                    @if (env('APP_LINK_APPSTORE_Apple'))
                        <a class="store-card" href="{{ env('APP_LINK_APPSTORE_Apple') }}" target="_blank"
                        rel="noopener" style="margin-right: 10px;margin-top:8px; vertical-align: middle;">
                            <span class="store-badge">
                                <img src="{{ url('assets/img/apple-store.png') }}"
                                    alt="Apple"
                                    style="width: 125px; border: 0; display: block;">
                            </span>
                        </a>
                    @endif
                </div>
            </div>
        @endif
      </div>
    </div>
   
   
    @include('Emails.partial.customer-footer', [
      'logoPath' => $logoPath,
      'fullAddress' => $fullAddress,
      'companyPhone' => $companyPhone,
      'companyEmail' => $companyEmail
    ])
  </div>
  @include('Emails.partial.admin-footer')
</body>
</html>

