@php
  use App\General\SettingsClass;
  use Illuminate\Support\Facades\Route;
  use Illuminate\Support\Facades\Config;
  use App\Models\User;
  use Illuminate\Support\Facades\DB;

  $logoPath = null;
  $companyName = env('APP_NAME', 'WMS');
  $companyAddress = '';
  $companyCity = '';
  $companyState = '';
  $companyPostCode = '';
  $companyCountry = '';
  $companyPhone = 'Contact Information';
  $companyEmail = env('EMAIL_ADDRESS', 'support@example.com');
  
  // Get admin settings data
    $admin = User::where('user_type', config('constants.user_types.admin'))->first();
    if ($admin) {
      $settings = DB::table('adminsettings')
          ->where('customer_id', $admin->id)
          ->get();
          
      // Transform into key-value pairs for easier access
      $settingsData = [];
      foreach ($settings as $setting) {
          $settingsData[$setting->key] = $setting->value;
      }
      
      // Get logo
      if (isset($settingsData['brand_logo_dark'])) {
          $logoPath = $settingsData['brand_logo_dark'];
      }
      
      // Get company information
      if (isset($settingsData['company_company_name'])) {
          $companyName = $settingsData['company_company_name'];
      }
      if (isset($settingsData['company_company_address'])) {
          $companyAddress = $settingsData['company_company_address'];
      }
      
      if (isset($settingsData['company_company_city'])) {
          $companyCity = $settingsData['company_company_city'];
      }
      
      if (isset($settingsData['company_company_state'])) {
          $companyState = $settingsData['company_company_state'];
      }
      
      if (isset($settingsData['company_company_post_code'])) {
          $companyPostCode = $settingsData['company_company_post_code'];
      }
      
      if (isset($settingsData['company_company_country'])) {
          $companyCountry = $settingsData['company_company_country'];
      }
      
      if (isset($settingsData['company_company_telephone'])) {
          $companyPhone = $settingsData['company_company_telephone'];
      }
      
      if (isset($settingsData['company_company_email'])) {
          $companyEmail = $settingsData['company_company_email'];
      }

        if (isset($settingsData['system_date_format'])) {
          $DateFormate = $settingsData['system_date_format'];
      }


    }
  
  
  // Format full address
  $fullAddress = $companyAddress;
  if (!empty($companyCity)) {
      $fullAddress .= ', ' . $companyCity;
  }
  if (!empty($companyState)) {
      $fullAddress .= ', ' . $companyState;
  }
  if (!empty($companyPostCode)) {
      $fullAddress .= ' ' . $companyPostCode;
  }
  if (!empty($companyCountry)) {
      $fullAddress .= ', ' . $companyCountry;
  }
  
  // Set defaults for variables that might not be provided
  if (!isset($subject)) {
    $subject = 'Purchase Confirmation';
  }
  
  // Status configuration for purchase confirmation
  $status_config = [
    'status_text' => 'Purchase Confirmed Successfully',
    'color' => '#22C55E', // Green
    'background' => 'linear-gradient(135deg, #22C55E 0%, #16A34A 100%)',
    'icon' => '✅',
    'message' => 'Your purchase has been confirmed successfully! Your plan is now active.',
  ];
@endphp
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>{{ $subject }}</title>
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@100;200;300;400;500;600;700;800;900&display=swap" rel="stylesheet">

  @include('Emails.partial.admin-style')
 
</head>
<body>
  <div class="email-template">
  @include('Emails.partial.header', ['logoPath' => $logoPath])
    <div class="email-body">
      <div class="email-body-box-one">
          <div class="email-body-icon-one">
            <img src="{{ url('assets/img/Symbol.png') }}" >
          </div>
          <h2>Payment Successful</h2>
          <p class="email-body-box-one-first-p">Thank you for your purchase.</p>
      </div>
      <div class="email-body-box-two">
        <div class="email-body-main-text">
          <p>
            Hi <span>{{ $name ?? 'Valued Customer' }}</span>,
            <br/><br/>
            Thank you for your purchase! We're excited to confirm that your order has been processed successfully. Below are the details of your purchase.
          </p>
        </div>
        <div class="email-body-details-box">
          <h3>
            Purchase Details
          </h3>
          <table>
            <tr>
              <td>Order ID</td>
              <td style="text-align: end;">
              {{ $order_id ?? 'N/A' }}
              </td>
            </tr>
            <tr>
              <td>Plan Name</td>
              <td style="text-align: end;">
              {{ $plan_name ?? 'N/A' }}
              </td>
            </tr>
            @if(isset($discount_amount) && $discount_amount > 0)
            <tr>
              <td>Original Price</td>
              <td style="text-align: end;">
              {{ number_format($original_price, 2) }} {{ $currency }}
              </td>
            </tr>
            <tr>
              <td>Discount ({{ $coupon_code }})</td>
              <td style="text-align: end;">
              {{ number_format($discount_amount, 2) }} {{ $currency }}
              </td>
            </tr>
            <tr>
              <td>Final Amount</td>
              <td style="text-align: end;">
              {{ number_format($price, 2) }} {{ $currency }}
              </td>
            </tr>
            @else
            <tr>
              <td>Amount</td>
              <td style="text-align: end;">
              {{ number_format($price, 2) }} {{ $currency }}
              </td>
            </tr>
            @endif
            <tr>
              <td>Duration</td>
              <td style="text-align: end;">
              {{ $interval ?? 'N/A' }} Month(s)
              </td>
            </tr>
            <tr>
              <td style="border-bottom: none;padding-bottom:0px;">Expiry Date</td>
              <td style="text-align: end;border-bottom: none;padding-bottom: 0px;">
              {{ $expiry_date ?? 'N/A' }}
              </td>
            </tr>
          </table>
        </div>
        <p class="email-body-thankyou-text">
        Your plan is now active and you can start using all the premium features right away. We're here to help you get the most out of your purchase.
        <br/>
        <a href="{{ env('FRONTEND_URL')}}" class="email-body-button">Access Your Dashboard</a>
        <br/><br/>
        If you have any questions about your purchase or need assistance, please don't hesitate to contact our support team.
        <br/><br/>
        Thank you,<br/>
          {{ $companyName }} Team
        </p>
      </div>
    </div>
    @include('Emails.partial.admin-footer')
  </div>

</body>
</html>