@php
   use App\Services\CompanyEmailDetails;

   // Get company details using global helper function
   $customer_id = $customer_id ?? null;
   $companyDetails = CompanyEmailDetails::getCompanyEmailDetails($customer_id);
   
    // Extract variables for easier use in template
    $logoPath = $companyDetails['logoPath'];
    $companyName = $companyDetails['companyName'];
    $companyAddress = $companyDetails['companyAddress'];
    $companyCity = $companyDetails['companyCity'];
    $companyState = $companyDetails['companyState'];
    $companyPostCode = $companyDetails['companyPostCode'];
    $companyCountry = $companyDetails['companyCountry'];
    $companyPhone = $companyDetails['companyPhone'];
    $companyEmail = $companyDetails['companyEmail'];
    $fullAddress = $companyDetails['companyAddressFull'];
@endphp

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>{{ $subject }}</title>
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@100;200;300;400;500;600;700;800;900&display=swap" rel="stylesheet">
  @include('Emails.partial.style', ['customer_id' => $customer_id])
</head>
<body>
  <div class="email-template">
    @include('Emails.partial.header', ['logoPath' => $logoPath])
    <div class="email-body">
      <div class="email-body-box-one">
          <div class="email-body-icon-one">
            <img src="{{ url('assets/img/Symbol' . ($status === 'approved' ? '-2' : '-3') . '.png') }}" alt="Status Icon">
          </div>
          <h2>
            @if ($status === 'approved')
              Document Approved
            @else
              Document Rejected
            @endif
          </h2>
          <p class="email-body-box-one-first-p">
            @if ($status === 'approved')
              Your required document has been reviewed and approved.
            @else
              Your required document requires attention.
            @endif
          </p>
      </div>
      <div class="email-body-box-two">
        <div class="email-body-main-text">
          <p>
            Hi <span>{{ $employee_name ?? 'there' }}</span>,
            <br/><br/>
            @if ($status === 'approved')
              @if (strpos($document_title, ',') !== false)
                Your required documents have been reviewed and approved by {{ $companyName }}.
              @else
                Your required document "<strong>{{ $document_title }}</strong>" has been reviewed and approved by {{ $companyName }}.
              @endif
            @else
              @if (strpos($document_title, ',') !== false)
                Your required documents have been reviewed and require your attention.
              @else
                Your required document "<strong>{{ $document_title }}</strong>" has been reviewed and requires your attention.
              @endif
            @endif
          </p>
        </div>
        <div class="email-body-details-box">
          <h3>Document Details</h3>
          <table>
            <tr>
              <td>{{ strpos($document_title, ',') !== false ? 'Document Titles' : 'Document Title' }}</td>
              <td style="text-align: end; word-break: break-word;">
                @if (strpos($document_title, ',') !== false)
                  <ul style="list-style: none; padding: 0; margin: 0; text-align: right;">
                    @foreach(explode(', ', $document_title) as $title)
                      <li style="margin-bottom: 5px;">{{ trim($title) }}</li>
                    @endforeach
                  </ul>
                @else
                  {{ $document_title }}
                @endif
              </td>
            </tr>
            <tr>
              <td>Status</td>
              <td style="text-align: end;">
                <span style="color: {{ $status === 'approved' ? '#059669' : '#DC2626' }}; font-weight: 600;">
                  {{ ucfirst($status) }}
                </span>
              </td>
            </tr>
            @if ($status === 'rejected' && !empty($rejection_reason))
            <tr>
              <td style="border-bottom: none;padding-bottom:0px;">Rejection Reason</td>
              <td style="text-align: end;border-bottom: none;padding-bottom: 0px; word-break: break-word;">{{ $rejection_reason }}</td>
            </tr>
            @endif
          </table>
        </div>
        @if ($status === 'rejected')
        <div class="email-alert-box">
          <table>
            <tr>
              <td style="width: 50px;vertical-align: baseline;text-align: start;">
                <img src="{{ url('assets/img/alert-icon.png') }}" alt="">
              </td>
              <td>
                <h3>Action Required</h3>
                <p>Please review the rejection reason above and resubmit your document with the necessary corrections.</p>
              </td>
            </tr>
          </table>
        </div>
        @endif
        <p class="email-body-thankyou-text">
          @if ($status === 'approved')
            Thank you for providing the required documentation.<br/>
          @else
            Please address the issues mentioned above and resubmit your document.<br/>
          @endif
          {{ $companyName }} Team
        </p>
        <br/>
        @if (env('APP_LINK_APPSTORE') || env('APP_LINK_APPSTORE_Apple'))
            <div class="app-download">
                <div style="display:flex;">
                    @if (env('APP_LINK_APPSTORE'))
                        <a class="store-card" href="{{ env('APP_LINK_APPSTORE') }}" target="_blank"
                            rel="noopener" style="margin-right: 10px; vertical-align: middle;">
                            <span class="store-badge">
                                <img src="https://play.google.com/intl/en_us/badges/static/images/badges/en_badge_web_generic.png"
                                    alt="Get it on Google Play"
                                    style="width: 150px; border: 0; display: block;">
                            </span>
                        </a>
                    @endif
                    @if (env('APP_LINK_APPSTORE_Apple'))
                        <a class="store-card" href="{{ env('APP_LINK_APPSTORE_Apple') }}" target="_blank"
                        rel="noopener" style="margin-right: 10px;margin-top:8px; vertical-align: middle;">
                            <span class="store-badge">
                                <img src="{{ url('assets/img/apple-store.png') }}"
                                    alt="Apple"
                                    style="width: 125px; border: 0; display: block;">
                            </span>
                        </a>
                    @endif
                </div>
            </div>
        @endif
      </div>
    </div>
   
    @include('Emails.partial.customer-footer', [
      'logoPath' => $logoPath,
      'fullAddress' => $fullAddress,
      'companyPhone' => $companyPhone,
      'companyEmail' => $companyEmail
    ])
  </div>
  @include('Emails.partial.admin-footer')
</body>
</html>
