@php
   use App\Services\CompanyEmailDetails;

   // Get company details using global helper function
   $customer_id = $customer_id ?? null;
   $companyDetails = CompanyEmailDetails::getCompanyEmailDetails($customer_id);
   
    // Extract variables for easier use in template
    $logoPath = $companyDetails['logoPath'];
    $companyName = $companyDetails['companyName'];
    $companyAddress = $companyDetails['companyAddress'];
    $companyCity = $companyDetails['companyCity'];
    $companyState = $companyDetails['companyState'];
    $companyPostCode = $companyDetails['companyPostCode'];
    $companyCountry = $companyDetails['companyCountry'];
    $companyPhone = $companyDetails['companyPhone'];
    $companyEmail = $companyDetails['companyEmail'];
    $fullAddress = $companyDetails['companyAddressFull'];
@endphp

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>{{ $subject }}</title>
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@100;200;300;400;500;600;700;800;900&display=swap" rel="stylesheet">
  @include('Emails.partial.style', ['customer_id' => $customer_id])
</head>
<body>
  <div class="email-template">
    @include('Emails.partial.header', ['logoPath' => $logoPath])
    <div class="email-body">
      <div class="email-body-box-one">
          <div class="email-body-icon-one">
            <img src="{{ url('assets/img/Symbol-4.png') }}" alt="Document Icon">
          </div>
          <h2>New Required Document</h2>
          <p class="email-body-box-one-first-p">A new required document has been added.</p>
      </div>
      <div class="email-body-box-two">
        <div class="email-body-main-text">
          <p>
            Hi <span>{{ $employee_name ?? 'there' }}</span>,
            <br/><br/>
            {{ $companyName }} has added a new required document that needs to be uploaded. Please review the details below and submit the document as soon as possible.
          </p>
        </div>
        <div class="email-body-details-box">
          <h3>Document Details</h3>
          <table>
            <tr>
              <td>Document Title</td>
              <td style="text-align: end;">{{ $document_title }}</td>
            </tr>
            @if (!empty($document_description))
            <tr>
              <td style="border-bottom: none;padding-bottom:0px;">Description</td>
              <td style="text-align: end;border-bottom: none;padding-bottom: 0px;">{{ $document_description }}</td>
            </tr>
            @endif
          </table>
        </div>
        <div class="email-alert-box">
          <table>
            <tr>
              <td style="width: 50px;vertical-align: baseline;text-align: start;">
                <img src="{{ url('assets/img/alert-icon.png') }}" alt="">
              </td>
              <td>
                <h3>Action Required</h3>
                <p>Please upload this required document through the mobile app or portal as soon as possible to maintain your active status.</p>
              </td>
            </tr>
          </table>
        </div>
        <p class="email-body-thankyou-text">
          Thank you for your cooperation.<br/>
          {{ $companyName }} Team
        </p>
        <br/>
        @if (env('APP_LINK_APPSTORE') || env('APP_LINK_APPSTORE_Apple'))
            <div class="app-download">
                <div style="display:flex;">
                    @if (env('APP_LINK_APPSTORE'))
                        <a class="store-card" href="{{ env('APP_LINK_APPSTORE') }}" target="_blank"
                            rel="noopener" style="margin-right: 10px; vertical-align: middle;">
                            <span class="store-badge">
                                <img src="https://play.google.com/intl/en_us/badges/static/images/badges/en_badge_web_generic.png"
                                    alt="Get it on Google Play"
                                    style="width: 150px; border: 0; display: block;">
                            </span>
                        </a>
                    @endif
                    @if (env('APP_LINK_APPSTORE_Apple'))
                        <a class="store-card" href="{{ env('APP_LINK_APPSTORE_Apple') }}" target="_blank"
                        rel="noopener" style="margin-right: 10px;margin-top:8px; vertical-align: middle;">
                            <span class="store-badge">
                                <img src="{{ url('assets/img/apple-store.png') }}"
                                    alt="Apple"
                                    style="width: 125px; border: 0; display: block;">
                            </span>
                        </a>
                    @endif
                </div>
            </div>
        @endif
      </div>
    </div>
   
    @include('Emails.partial.customer-footer', [
      'logoPath' => $logoPath,
      'fullAddress' => $fullAddress,
      'companyPhone' => $companyPhone,
      'companyEmail' => $companyEmail
    ])
  </div>
  @include('Emails.partial.admin-footer')
</body>
</html>
