@php
   use App\Services\CompanyEmailDetails;
 
   // Ensure customer_id is available
   $customer_id = $customer_id ?? null;
   $companyDetails = CompanyEmailDetails::getCompanyEmailDetails($customer_id);
   
    // Extract variables for easier use in template
    $logoPath = $companyDetails['logoPath'];
    $companyName = $companyDetails['companyName'];
    $companyAddress = $companyDetails['companyAddress'];
    $companyCity = $companyDetails['companyCity'];
    $companyState = $companyDetails['companyState'];
    $companyPostCode = $companyDetails['companyPostCode'];
    $companyCountry = $companyDetails['companyCountry'];
    $companyPhone = $companyDetails['companyPhone'];
    $companyEmail = $companyDetails['companyEmail'];
 
 
  // Format full address
  $fullAddress = $companyAddress;
  if (!empty($companyCity)) {
      $fullAddress .= ', ' . $companyCity;
  }
  if (!empty($companyState)) {
      $fullAddress .= ', ' . $companyState;
  }
  if (!empty($companyPostCode)) {
      $fullAddress .= ' ' . $companyPostCode;
  }
  if (!empty($companyCountry)) {
      $fullAddress .= ', ' . $companyCountry;
  }
@endphp

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>{{ $subject }}</title>
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@100;200;300;400;500;600;700;800;900&display=swap" rel="stylesheet">
  @php
    \Illuminate\Support\Facades\Log::info('OTP Email Template: Before including style partial', [
      'customer_id' => $customer_id ?? 'NULL',
      'email' => $email ?? 'NULL',
      'template_path' => 'Emails.subcontractor-welcome'
    ]);
    
    // Check if the partial file exists
    $stylePartialPath = resource_path('views/Emails/partial/style.blade.php');
    $stylePartialExists = file_exists($stylePartialPath);
    \Illuminate\Support\Facades\Log::info('OTP Email Template: Style partial file check', [
      'path' => $stylePartialPath,
      'exists' => $stylePartialExists,
      'readable' => $stylePartialExists ? is_readable($stylePartialPath) : false
    ]);
  @endphp
  @include('Emails.partial.style', ['customer_id' => $customer_id])
  @php
    \Illuminate\Support\Facades\Log::info('OTP Email Template: After including style partial');
  @endphp
</head>
<body>
  <div class="email-template">
    @include('Emails.partial.header', ['logoPath' => $logoPath])
    <div class="email-body">
      <div class="email-body-box-one">
          <div class="email-body-icon-one">
            <img src="{{ url('assets/img/Symbol.png') }}" >
          </div>
          <h2>Welcome to {{ $companyName }}</h2>
          <p class="email-body-box-one-first-p">{{ isset($password) && $password ? 'Your account has been created successfully' : 'Your account has been associated successfully' }}</p>
      </div>
      <div class="email-body-box-two">
        <div class="email-body-main-text">
          <p>
            Hi <span>{{ $name }}</span>,
            <br/><br/>
            @if (isset($password) && $password)
            Your account has been created successfully. You can now log in to access our services and features.
            @else
            Your account has been associated with {{ $companyName }}. You can now log in to access our services and features using your existing credentials.
            @endif
          </p>
        </div>
        <div class="email-body-details-box">
          <h3>
           Account Information
          </h3>
          <table>
            <tr>
              <td>Name</td>
              <td style="text-align: end;">
                {{ $name }}
              </td>
            </tr>
            <tr>
              <td>Email</td>
              <td style="text-align: end;">
                {{ $email }}
              </td>
            </tr>
            @if (isset($password) && $password)
            <tr>
              <td>Password</td>
              <td style="text-align: end;">
                {{ $password }}
              </td>
            </tr>
            @endif
            <tr>
              <td>Company Name</td>
              <td style="text-align: end;">
                {{ $company_name }}
              </td>
            </tr>
            <tr>
              <td style="border-bottom: none;padding-bottom:0px;">Workspace</td>
              <td style="text-align: end;border-bottom: none;padding-bottom: 0px;">{{ $workspace_name }}</td>
            </tr>
          </table>
          <h3 style="margin-top:20px;">
            Account Summary
          </h3>
          <table>
          <tr>
              <td>Account Status</td>
              <td style="text-align: end;">
              Active
              </td>
            </tr>
            <tr>
              <td>Account Type</td>
              <td style="text-align: end;">
              Subcontractor
              </td>
            </tr>
            <tr>
              <td style="border-bottom: none;padding-bottom:0px;">Created Date</td>
              <td style="text-align: end;border-bottom: none;padding-bottom: 0px;">{{ date('M d, Y') }}</td>
            </tr>
          </table>
          </div>
        <div class="email-alert-box">
          <table>
            <tr>
              <td style="width: 50px;vertical-align: baseline;text-align: start;">
                <img src="{{ url('assets/img/alert-icon.png') }}" alt="">
              </td>
              <td>
                <h3>Quick Access</h3>
                <p>
                    Use the login button below to access your account.
                    @if (isset($password) && $password)
                    <p>Save your login credentials in a secure location for future reference.</p>
                    @else
                    <p>Use your existing credentials to log in to the web portal.</p>
                    @endif
                </p>
              </td>
            </tr>
          </table>
        </div>
        <p class="email-body-thankyou-text">
            Your account has been successfully {{ isset($password) && $password ? 'created' : 'associated' }} with {{ $company_name }}. You can now log in to access our services and features.
            <br/><br/>
            To get started, please click the button below to log in to your account:
            <br/><br/>
            <a href="{{ env('FRONTEND_URL') }}" target="_blank" class="email-body-button">Login to Your Account</a>
            <br/><br/>
            If you have any questions or need assistance, feel free to contact our support team.
            <br/><br/>
            @if (isset($password) && $password)
            <strong>Important:</strong> Please keep your login credentials secure and do not share them with anyone.
            @else
            <strong>Note:</strong> Please use your existing login credentials to access your account. Your password remains unchanged.
            @endif
          <br/><br/>
          Thank you,<br/>
          {{ $companyName }} Team
        </p>
      </div>
    </div>
   
   
    @include('Emails.partial.customer-footer', [
      'logoPath' => $logoPath,
      'fullAddress' => $fullAddress,
      'companyPhone' => $companyPhone,
      'companyEmail' => $companyEmail
    ])
  </div>
  @include('Emails.partial.admin-footer')
</body>
</html>
