<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\MobileV2\MobileAuthController;
use App\Http\Controllers\MobileV2\SubcontractorEmployeeController;
use App\Http\Controllers\MobileV2\AttendanceController;
use App\Http\Controllers\MobileV2\MeetingController;
use App\Http\Controllers\MobileV2\ProfileController;
/*
|--------------------------------------------------------------------------
| Mobile API V2 Routes
|--------------------------------------------------------------------------
|
| This file contains routes for Mobile API V2 endpoints.
| All routes here are prefixed with 'api/v2/mobile'.
|
*/

// Public routes (no authentication required)
Route::post('/login', [MobileAuthController::class, 'login']);

// Routes - accessible by subcontractor employees
Route::middleware(['auth:api,subcontractor_employee'])->group(function () {
    Route::post('/logout', [MobileAuthController::class, 'logout']);
    Route::post('/reset-password', [MobileAuthController::class, 'resetPassword']);
});

// Routes - accessible by subcontractor employees only
Route::middleware(['auth:subcontractor_employee'])->group(function () {
    // Get subcontractors list with projects
    Route::get('/subcontractors', [SubcontractorEmployeeController::class, 'getSubcontractors']);
    
    // Get subcontractor details
    Route::get('/subcontractors/{id}', [SubcontractorEmployeeController::class, 'getSubcontractorDetails']);
    
    // Respond to project invitation (accept/reject)
    Route::post('/invitations/respond', [SubcontractorEmployeeController::class, 'respondToInvitation']);
    
    // Get required documents for a project
    Route::post('/documents/required', [SubcontractorEmployeeController::class, 'getRequiredDocuments']);
    
    // Submit documents
    Route::post('/documents/submit', [SubcontractorEmployeeController::class, 'storeDocuments']);
    
    // Get induction documents for a customer/workspace
    Route::post('/induction-documents', [SubcontractorEmployeeController::class, 'getInductionDocuments']);
    
    // Sign an induction document
    Route::post('/induction-documents/sign', [SubcontractorEmployeeController::class, 'signInductionDocument']);

    // Get document and induction statuses for a project and subcontractor
    Route::post('/documents/statuses', [SubcontractorEmployeeController::class, 'getDocumentStatuses']);

    //Attendance routes
    Route::get('/attendance/roster-list', [AttendanceController::class, 'getRosterList']);
    // Check-in for attendance
    Route::post('/attendance/checkin', [AttendanceController::class, 'checkIn']);
    // Check-out for attendance
    Route::post('/attendance/checkout', [AttendanceController::class, 'checkout']);
    // Break-in
    Route::post('/attendance/breakin', [AttendanceController::class, 'breakIn']);
    // Get last break-in
    Route::get('/attendance/last-breakin', [AttendanceController::class, 'lastBreakIn']);
    // Break-out
    Route::post('/attendance/breakout', [AttendanceController::class, 'breakOut']);
    // Get last check-in
    Route::get('/attendance/last-checkin', [AttendanceController::class, 'last_check_in']);

    // Meeting routes
    Route::post('/meetings/get-employee-meetings', [MeetingController::class, 'getEmployeeMeetingBeforeCheckIn']);
    Route::get('/meetings/get-employee', [MeetingController::class, 'getEmployeeMeetings']);
    // Join/Leave meeting
    Route::post('/meetings/attendance', [MeetingController::class, 'addMeetingAttendance']);
    // Sign meeting document
    Route::post('/meetings/sign-document', [MeetingController::class, 'signDocument']);

    // Profile routes
    // Get personal details and emergency contacts combined
    Route::get('/emp-personal-details-and-emergency-contacts', [ProfileController::class, 'getPersonalDetailsAndEmergencyContacts']);
    // Store/Update personal details and emergency contacts combined
    Route::post('/emp-personal-details-and-emergency-contacts-store', [ProfileController::class, 'storePersonalDetailsAndEmergencyContacts']);
    // Get attendance statistics
    Route::post('/get-attendance-stats', [ProfileController::class, 'getAttendanceStats']);
    // Get full profile
    Route::get('/profile', [ProfileController::class, 'profile']);
    
});

// Test route for subcontractor employees
Route::middleware(['auth:subcontractor_employee', 'subcontractor_employee'])->group(function () {
    Route::get('/subcontractor-employee/test', function (Request $request) {
        return response()->json([
            'message' => 'Mobile API V2 subcontractor employee test route is working!',
            'status' => 'success',
            'timestamp' => now()->toDateTimeString(),
            'user' => [
                'id' => $request->user()->id ?? null,
                'email' => $request->user()->email ?? null,
                'name' => trim(($request->user()->first_name ?? '') . ' ' . 
                              ($request->user()->middle_name ?? '') . ' ' . 
                              ($request->user()->last_name ?? '')),
                'type' => get_class($request->user()),
            ],
        ], 200);
    });
});
