<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Traits\AdminAuthTrait;
use Illuminate\Http\Request;

class AdminAuthController extends Controller
{
    
    use AdminAuthTrait;

    public function login(Request $request)
    {
        $request->merge(['platform' => 'web']);
        return $this->handleAdminLogin($request);
    }

    public function mobileLogin(Request $request)
    {
        // Add platform identifier to request
        $request->merge(['platform' => 'mobile']);
        return $this->handleAdminLogin($request);
    }

    /**
     * Get permissions for the authenticated user
     * Returns permissions based on user type:
     * - Customer: Returns permissions of the 1st tier
     * - Employee: Returns permissions of the assigned tier
     */
    public function getPermissions(Request $request)
    {
        return $this->handleGetPermissions($request);
    }

  
}
