<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class CustomerController extends Controller
{
 
    public function store(Request $request)
    {
        return $this->handleCustomerCreate($request);   
    }
    public function signup(Request $request)
    {
        return $this->signuphandle($request);   
    }

    public function show(Request $request)
    {
        return $this->handleCustomerShow($request);   
    }

    public function view(Request $request)
    {
        $id=$request->id;

        return $this->handleCustomerProfile($id);   
    }

    public function passwordReset(Request $request){
        return $this->handleAdminResetPassword($request);    
    }

    public function editCustomer(Request $request){
        return $this->handleAdminCustomerEdit($request); 
    }
    public function deleteCustomer($id){
        return $this->handleAdminCustomerDelete($id); 
    }
    public function toggleUserLogin(Request $request)
    {
        return $this->handleToggleUserLogin($request);
    }
    public function companyLogin(Request $request)
    {
        return $this->handleCompanyLogin($request);
    }
    public function assignPlan(Request $request)
    {
        return $this->handleAssignPlan($request);
    }
    
    /**
     * Get authenticated customer profile with plan details
     * 
     * @return \Illuminate\Http\JsonResponse
     */
    public function getProfile()
    {
        return $this->getCustomerProfile();
    }
    
    /**
     * Update authenticated customer profile
     * 
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function updateProfile(Request $request)
    {
        return $this->updateCustomerProfile($request);
    }
}
