<?php

namespace App\Http\Controllers\Traits;
use Illuminate\Http\Request;
use App\Models\CustomDomainRequest;

trait CustomDomainRequestTrait {  


    protected function  CustomDomainRequestIndex($customDomainRequest , $request)
    {
        return $this->getLatestData($customDomainRequest, $request, ['user']);
    }

    protected function CustomDomainRequestStore($request) {
        $validator = $this->customDomainValidation($request);
        if ($validator->fails()) {
            return $this->handleValidationFailure($validator);
        }
        $validatedData = $validator->validated();
        $user=auth()->user();   
        $validatedData['created_by']= $user->id; 
        $validatedData['workspace_id']= $user->current_workspace_id;
        $validatedData['status'] = 0;
        $customDomainRequest = CustomDomainRequest::create($validatedData); 
        if (!$customDomainRequest )    {
            return $this->message('Failed to create Custom Domain');
        }
        return $this->success($customDomainRequest, 'Category created successfully');
        
    }

    protected function CustomDomainRequestUpdateStatus(Request $request)
    {
        $validator = $this->customDomainStatusValidation($request);
        if ($validator->fails()) {
            return $this->handleValidationFailure($validator);
        }
        $validatedData = $validator->validated();
        $customDomainRequest = CustomDomainRequest::find($validatedData['id']);
        if (!$customDomainRequest) {
            return $this->message('Custom Domain Request not found', 404);
        }
        if($validatedData['status'] == config('constants.custom_domain_status.approve')){
            $customDomainRequest->status = config('constants.custom_domain_status.approve');
        }
        elseif($validatedData['status'] == config('constants.custom_domain_status.reject')){
            $customDomainRequest->status = config('constants.custom_domain_status.reject');
        }
        if (!$customDomainRequest->save()) {
            return $this->message('Failed to update status', 500);
        }
        return $this->success($customDomainRequest, 'Status updated successfully');
    }

     
    protected function CustomDomainRequestDelete($id)
    {
        $customDomainRequest = CustomDomainRequest::find($id);
        if (!$customDomainRequest) {
            return $this->message('Custom Domain Request not found', 404);
        }
        if (!$customDomainRequest->delete()) {
            return $this->message('Failed to delete Custom Domain Request', 500);
        }
        return $this->success(null, 'Custom Domain Request deleted successfully');
    }
    


}

