<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class AdminMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle(Request $request, Closure $next)
    {
      
        if (Auth::check() && Auth::user()->user_type == config('constants.user_types.admin')) {
            return $next($request); // Allow access
        }

        // Redirect or abort if the user type is not 2
        return response()->json(['message' => 'Unauthorized' , 'statusCode'=> 403], 403);
    }
}
