<?php


namespace App\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use App\Http\Controllers\Traits\EmailTrait;
class SendEmailJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels, EmailTrait;

    protected $schedulerData;

    public function __construct($schedulerData)
    {
        $this->schedulerData = $schedulerData;
    }

    public function handle()
    {
        $this->SendInstantEmail($this->schedulerData);
    }
}



?>