<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;

class CompanyContactPerson extends BaseModel
{
    use HasFactory;

    protected $table = 'company_contact_persons';

    protected $fillable = [
        'company_id',
        'name',
        'email',
        'phone',
        'role',
    ];

    /**
     * Get the company that owns the contact person.
     */
    public function company()
    {
        return $this->belongsTo(Company::class);
    }
}
