<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;

class DemoRequest extends BaseModel
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'first_name',
        'last_name',
        'work_email',
        'company_name',
        'phone',
        'company_type',
        'email_consent',
        'company_size',
    ];

    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'demo_requests';

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_consent' => 'boolean',
    ];
}

