<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class GeneratedPdfReport extends BaseModel
{
    use HasFactory;

    protected $fillable = ['report_id', 'path','report_type' , 'customer_id' , 'workspace_id' ];

    protected $hidden = [
        'customer_id',
        'workspace_id',
    ];
    public function inspectionPlan()
    {
        return $this->belongsTo(InspectionPlan::class, 'report_id', 'id');
    }
}
