<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class IncidentClassificationReport extends BaseModel
{
    use HasFactory;

    // Define table name
    protected $table = 'incident_classification_reports';

    // Define fillable fields
    protected $fillable = [
        'incident_report_id',
        'injury_classification_id',
        'details',
        'type'
    ];

    // Define relationships
    public function incidentReport()
    {
        return $this->belongsTo(IncidentReport::class, 'incident_report_id');
    }

    public function injuryClassification()
    {
        return $this->belongsTo(IncidentInjuryClassification::class, 'injury_classification_id');
    }


}
