<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class IncidentEmployerDetail extends BaseModel
{
    use HasFactory;

    protected $table = 'incident_employer_details';

    // Define fillable fields
    protected $fillable = [
        'incident_report_id',
        'employer_id',
        'employer_name',
        'employer_address',
        'employer_number',
        'supervisor',
        'contact_number',
        'is_employer_worker',
        'is_employer_worker_details'
    ];

    // Define relationships
    public function incidentReport()
    {
        return $this->belongsTo(IncidentReport::class, 'incident_report_id');
    }

    public function employer()
    {
        return $this->belongsTo(EmpPersonalDetails::class, 'employer_id');
    }
}
