<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class IncidentInvolvedPersonTraining extends BaseModel
{
    use HasFactory;

    protected $table = 'incident_involved_person_trainings';

    // Define fillable fields
    protected $fillable = [
        'training_id',
        'incident_involved_person_id',
        'incident_report_id'
    ];

    // Define relationships
    public function incidentReport()
    {
        return $this->belongsTo(IncidentReport::class, 'incident_report_id');
    }

    public function involvedPerson()
    {                    
        return $this->belongsTo(IncidentInvolvedPersonDetail::class, 'incident_involved_person_id');
    }

    public function training()
    {
        return $this->belongsTo(Training::class, 'training_id');
    }
}
