<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class InspectionPlanChecklist extends BaseModel
{
    use HasFactory;
    protected $fillable = [
        'inspection_plan_id',
        'itp_reference_id',
        'itpc_number',
        'name',
        'status',
        'is_completed',
        'checklist_note',
        'customer_id',
        'workspace_id',
    ];

    protected $hidden = [
        'customer_id',
        'workspace_id',
    ];
    
    public function inspection_plan_meta()
    {
        return $this->hasMany(InspectionPlanMeta::class, 'itpc_id', 'id');
    }

    public function images()
    {
        return $this->hasMany(InspectionImage::class, 'itpc_id', 'id');
    }

    public function general()
    {
        return $this->hasOne(InspectionPlanGeneral::class, 'iptc_id', 'id');
    }

    public function metas()
    {
        return $this->hasMany(InspectionPlanMeta::class, 'itpc_id', 'id');
    }

    public function signatures()
    {
        return $this->hasMany(InspectionPlanSignature::class, 'itpc_id', 'id');
    }
}
