<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class MeetingDocumentNote extends BaseModel
{
    use HasFactory;
    protected $guarded =[];
    protected $fillable = [
        'meeting_id',
        'project_id',
        'site_id',
        'project_number',
        'date',
        'day_of_the_week',
        'time_start',
        'time_finish',
        'weather_forecast_for_today',
        'prestart_facilitated_by',
        'comments_on_weather',
        'additonal_items',
        'office_review_comments',
        'prestart_meeting_notes',
        'type_of_setting',
    ];
    public function meeting_note_documents_pdf()
    {
        return $this->hasOne(MeetingNoteDocumentsPdf::class,'meeting_note_id','id');
    }
    public function toolboxActions()
    {
        return $this->hasMany(ToolboxAction::class, 'meeting_document_id');
    }

    public function meeting_note_signatures()
    {
        return $this->hasMany(MeetingNoteSignature::class,'employee_note_id','id')->with('employee');
    }
}
