<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PermissionsModules extends BaseModel
{
    use HasFactory;

    protected $fillable = ['title','customer_id','workspace_id' , 'priority' , 'image','link'];

    protected $hidden = [
        'customer_id',
        'workspace_id',
    ];


    public function permissionsSubModule()
    {
        return $this->hasMany(PermissionsSubModules::class, 'module_id', 'id');
    }

    /**
     * Get the FAQs that belong to this module
     */
    public function faqs()
    {
        return $this->hasMany(FAQ::class, 'module_id', 'id');
    }
}
