<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ProjectSite extends BaseModel
{
    use HasFactory;
    protected $fillable = [
        'project_id',
        'site_id',
        'user_id'
    ];
        public function siteDetails()
    {
        return $this->belongsTo(Sites::class, 'site_id');
    }
    
    public function project()
    {
        return $this->belongsTo(Project::class, 'project_id');
    }
}
