<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class ReferralClick extends Model
{
    use HasFactory;

    protected $fillable = [
        'referral_code',
        'ip_address',
        'user_agent',
        'clicked_at',
    ];

    protected $casts = [
        'clicked_at' => 'datetime',
    ];

    /**
     * Get the referral user that owns this click
     */
    public function referralUser()
    {
        return $this->belongsTo(User::class, 'referral_code', 'referral_code');
    }
}
