<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;

class ReferralCommissionPayout extends BaseModel
{
    use HasFactory;

    protected $fillable = [
        'commission_id',
        'payout_id',
        'commission_amount',
        'status',
        'included_at',
        'processed_at',
        'notes',
    ];

    protected $casts = [
        'commission_amount' => 'decimal:2',
        'included_at' => 'datetime',
        'processed_at' => 'datetime',
    ];

    public function commission()
    {
        return $this->belongsTo(ReferralCommission::class, 'commission_id');
    }

    public function payout()
    {
        return $this->belongsTo(ReferralPayout::class, 'payout_id');
    }

    public function markAsRequested()
    {
        $this->update([
            'status' => 'requested',
            'included_at' => now(),
        ]);
    }

    public function markAsCompleted()
    {
        $this->update([
            'status' => 'completed',
            'processed_at' => now(),
        ]);
    }

    public function markAsRejected($notes = null)
    {
        $this->update([
            'status' => 'rejected',
            'processed_at' => now(),
            'notes' => $notes,
        ]);
    }

    public function scopeRequested($query)
    {
        return $query->where('status', 'requested');
    }

    public function scopeCompleted($query)
    {
        return $query->where('status', 'completed');
    }

    public function scopeRejected($query)
    {
        return $query->where('status', 'rejected');
    }
}
