<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ReferralSetting extends Model
{
    use HasFactory;

    protected $fillable = [
        'commission_type',
        'commission_value',
        'payout_threshold',
        'is_active',
        'meta_data',
    ];

    protected $casts = [
        'is_active' => 'boolean',
        'meta_data' => 'array',
    ];

    public static function getActive()
    {
        return static::where('is_active', true)->first() ?? static::create([
            'commission_type' => 'percentage',
            'commission_value' => 10.00,
            'payout_threshold' => 100.00,
            'is_active' => true,
        ]);
    }

    public function calculateCommission($planPrice)
    {
        if ($this->commission_type === 'percentage') {
            return ($planPrice * $this->commission_value) / 100;
        }
        
        return $this->commission_value;
    }
}
