<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class RosterTemplate extends BaseModel
{
    use HasFactory;
    protected $fillable = [
        'start_time',
        'end_time',
        'color_code',
        'break_minutes',
        'shift_notes',
        'repeat_shift',
        'repeat_every',
        'end_date',
        'is_saved',
        'created_by',
        'customer_id',
        'workspace_id',
        'status',
        'working_hours',
        'site_id',
        'project_id',
    ];

    protected $hidden = [
        'customer_id',
        'workspace_id',
    ];

    public function RosterTemplate()
    {
        return $this->belongsTo(RosterTemplate::class, 'roster_template_id');
    }
    public function rosterAssign()
    {
        return $this->hasOne(RosterAssign::class, 'id', 'roster_template_id');
    }

    public function assigns()
    {
        return $this->hasMany(RosterAssign::class, 'roster_template_id'); // Adjust the foreign key name if necessary
    }

}
