<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletes;

class SiteDiaryTask extends BaseModel
{
    use SoftDeletes;

    protected $table = 'site_diary_tasks';

    protected $fillable = [
        'site_diary_id',
        'title',
        'is_completed',
        'customer_id',
        'workspace_id',
    ];

    protected $hidden = [
        'customer_id',
        'workspace_id',
    ];

    protected $casts = [
        'is_completed' => 'boolean',
    ];

    // Relationships
    public function siteDiary()
    {
        return $this->belongsTo(SiteDiary::class, 'site_diary_id');
    }

    // Log relationship
    public function logs()
    {
        return $this->morphMany(SiteDiaryLog::class, 'loggable');
    }
}