<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Sites extends BaseModel
{
    use HasFactory;
    protected $table = 'sites';
    protected $fillable = [
        'title',
        'description',
        'longitude',
        'latitude',
        'area_radius',
        'project_id', 
        'company_client', 
        'external_id', 
        'supervisor_id',
        'site_state',
        'street_address',
        'created_by',
        'forman_id',
        'sso_id',
        'del',
        'status',
        'customer_id',
        'workspace_id',
    ];

    protected $hidden = [
        'customer_id',
        'workspace_id',
    ];

    public function project()
    {
        return $this->belongsTo(Project::class, 'project_id');
    }
   
    public function emppersonaldetails()
    {
        return $this->belongsTo(EmpPersonalDetails::class,'supervisor_id', 'emp_id');
    }

    public function supervisor()
    {
        return $this->belongsTo(EmpPersonalDetails::class,'supervisor_id', 'emp_id');
    }

    public function company()
    {
        return $this->belongsTo(Company::class,'company_client');
    }

    public function siteSafetyOfficer()
    {
        return $this->belongsTo(EmpPersonalDetails::class,'sso_id', 'emp_id');
    }

    public function forman()
    {
        return $this->belongsTo(EmpPersonalDetails::class,'forman_id', 'emp_id');
    }

    public function documents()
    {
        return $this->hasMany(SiteDocument::class, 'site_id');
    }
}
