<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;

class SubcontractorContactPerson extends BaseModel
{
    use HasFactory;

    protected $table = 'subcontractor_contact_persons';

    protected $fillable = [
        'subcontractor_id',
        'name',
        'email',
        'phone',
        'role',
        'customer_id',
        'workspace_id',
        'del',
    ];

    /**
     * Get the subcontractor that owns the contact person.
     */
    public function subcontractor()
    {
        return $this->belongsTo(User::class, 'subcontractor_id');
    }
}
