<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SwmsProtectionToolPivot extends BaseModel
{
    use HasFactory;
    protected $casts = [
        'protection_tool_id' => 'integer',
    ];

    protected $fillable = [
        'swms_id', 
        'protection_tool_id',
    ];

    // Relationship with the Swms model
    public function swms()
    {
        return $this->belongsTo(Swms::class, 'swms_id');
    }

    // Relationship with the ProtectionTool model
    public function protectionTool()
    {
        return $this->belongsTo(SwmsProtectionTool::class, 'protection_tool_id');
    }
}
