<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TenderParticipant extends BaseModel
{
    use HasFactory;

    protected $fillable = [
        'tender_id',
        'user_id',
        'invite_status',
        'viewed_at',
        'customer_id',
        'workspace_id',
    ];

    protected $hidden = [
        'customer_id',
        'workspace_id',
    ];

    /**
     * Get the tender associated with this participant.
     */
    public function tender()
    {
        return $this->belongsTo(Tender::class, 'tender_id');
    }

    /**
     * Get the user (participant) associated with this record.
     */
    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }
}

