<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TierPermissions extends BaseModel
{
    use HasFactory;

    protected $fillable = ['tier_id', 'sub_module_id', 'maintain', 'view','module_id'];


    public function permissionsSubModule()
    {
        return $this->hasMany(PermissionsSubModules::class, 'sub_module_id', 'id');
    }

    public function subModule()
    {
        return $this->hasOne(PermissionsSubModules::class, 'id', 'sub_module_id');
    }

    public function tier()
    {
        return $this->hasMany(Tier::class, 'tier_id', 'id');
    }
}
