<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class WhsqSignature extends BaseModel
{
    protected $table = 'whsq_signature';
    protected $with = ['employee'];
    protected $fillable = [
        'whsq_report_id',
        'customer_id',
        'workspace_id',
        'employee_id',
        'is_site_employee',
        'signature',
        'job_description',
        'induction_date'
    ];

    protected $casts = [
        'is_site_employee' => 'boolean',
    ];

    protected $hidden = [
        'customer_id',
        'workspace_id',
    ];

    public function whsqReport()
    {
        return $this->belongsTo(WhsqReport::class, 'whsq_report_id');
    }

    public function employee(){
        return $this->belongsTo(EmpPersonalDetails::class, 'employee_id','emp_id')->select('emp_id','first_name','middle_name','last_name');
    }
} 