<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateEmpCompanyDetailsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('emp_company_details', function (Blueprint $table) {

            $table->id();
            $table->string('employee_email');
            $table->string('employment_type');
            $table->integer('customer_id')->nullable();
            $table->integer('workspace_id')->nullable();
            $table->string('access_role');
            $table->string('work_permit_type');
            $table->string('tax_file_no');
            $table->string('tier_id')->nullable();
            $table->string('employment_start_date');
            $table->string('employment_end_date')->nullable();
            $table->string('attendance_effective_from');
            $table->string('active')->default('0');
            $table->string('invited')->default('0');
            $table->string('password')->nullable();
            $table->string('approved')->default('0');
            $table->string('rejected')->default('0');
            $table->string('approved_by')->nullable();
            $table->string('approved_status')->nullable();
            $table->string('approved_at')->nullable();
            $table->string('remember_token')->nullable();
            $table->string('is_submitted')->default('0');
            $table->string('compeleted')->default('0');
            $table->string('credentials')->default('0');
            $table->string('created_by');
            $table->string('del')->default('0');
            $table->timestamps();
            
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('emp_company_details');
    }
}
