<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateMeetingGuestUsersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('meeting_guest_users', function (Blueprint $table) {
            $table->id();
            $table->integer('meeting_id');
            $table->string('name');
            $table->string('email');
            $table->string('phone_number');
            $table->string('occupation')->nullable();
            $table->string('details')->nullable();
            $table->integer('added_by')->nullable();
            $table->date('meeting_date')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('meeting_guest_users');
    }
}
