<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateEmployeeAttendancesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('employee_attendances', function (Blueprint $table) {
            $table->id();
            $table->integer('employee_id');
            $table->integer('customer_id')->nullable();
            $table->integer('workspace_id')->nullable();
            $table->integer('site_id');
            $table->integer('added_by')->nullable();
            $table->integer('status')->default(0);
            $table->string('approved_by')->nullable();
            $table->string('check_in')->nullable();
            $table->string('check_out')->nullable();
            $table->date('date')->nullable();
            $table->float('working_hours')->nullable();
            $table->string('image')->nullable();
            $table->integer('checkout_type')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('employee_attendances');
    }
}
