<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateIncidentFinalClassificationsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('incident_final_classifications', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('incident_report_id')->default(0);  
            $table->integer('final_incident_name')->default(0);   // Plant/Property   
            $table->text('final_incident_details')->nullable();
            $table->integer('is_rehabilitation')->default(0); 
            $table->string('return_to_duty_date')->nullable();     
            $table->string('rtw_date')->nullable();
            $table->integer('total_lost_days')->default(0);  
            $table->integer('is_worker_notified')->default(0);     
            $table->integer('notified_by_whom')->default(0);
            $table->string('date')->nullable();   
            $table->string('time')->nullable();     
            $table->text('details')->nullable();
            $table->timestamps();
            $table->foreign('incident_report_id') ->references('id') ->on('incident_reports')->onDelete('cascade')->onUpdate('cascade');

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('incident_final_classifications');
    }
}
