<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateLinkManagementTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('link_management', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('role_id');
            $table->unsignedBigInteger('tier_id');
            $table->integer('customer_id')->nullable(); // Makes the column nullable
            $table->integer('workspace_id')->nullable(); // Makes the column nullable
            $table->unsignedBigInteger('created_by');
            $table->string('title');
            $table->string('description')->nullable();
            $table->boolean('status')->default(0);
            $table->text('working_days')->nullable();
            $table->integer('number_of_days')->default(1);
            $table->time('start_time')->nullable();
            $table->time('end_time')->nullable();
            $table->decimal('required_hours', 10, 2)->nullable();
            $table->unsignedTinyInteger('paid_break')->default(0);
            $table->string('color_code')->nullable();
            $table->string('secret_key', 35)->unique();
            $table->string('team_ids')->nullable();
            $table->string('name')->nullable();
            $table->string('email')->nullable();
            $table->string('phone')->nullable();
            $table->string('address')->nullable();
            $table->string('company_name')->nullable();
            $table->string('company_logo')->nullable();
            $table->integer('site_id')->nullable();
            $table->timestamps();
            
            // Define foreign key constraints
            $table->foreign('role_id')->references('id')->on('roles')->onDelete('cascade');
            $table->foreign('tier_id')->references('id')->on('tiers')->onDelete('cascade');
            $table->foreign('created_by')->references('id')->on('emp_company_details')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('link_management');
    }
}
