<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateInspectionPlanSignaturesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('inspection_plan_signatures', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('inspection_plan_id');
            $table->unsignedBigInteger('itpc_id')->nullable();
            $table->unsignedBigInteger('employee_id')->nullable();
            $table->string('employee_name')->nullable();
            $table->string('signature_type')->nullable();


            $table->string('employee_type')->nullable();
            $table->string('signature')->nullable();
            $table->date('date')->nullable();
            $table->time('time')->nullable();
            $table->string('del')->default(0);

            $table->timestamps();

            $table->foreign('inspection_plan_id')->references('id')->on('inspection_plans')->onDelete('cascade')->onUpdate('cascade');
            $table->foreign('itpc_id')->references('id')->on('inspection_plan_checklists')->onDelete('cascade')->onUpdate('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('inspection_plan_signatures');
    }
}
